/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging.binarytree;
import java.awt.Color;
import javax.swing.*;
import org.rhwlab.beans.*;
import org.rhwlab.db.MySql;
import java.awt.Dimension;
/**
 *
 * @author gevirl
 */
public class TreeFrame extends JFrame {
    public TreeFrame(SeriesEmbryo embryo)throws Exception {
        
        JScrollPane scroll = new JScrollPane();
        JPanel mainPanel = new JPanel();
        scroll.setViewportView(mainPanel);
        mainPanel.setLayout(new BoxLayout(mainPanel,BoxLayout.Y_AXIS));
        EmbryoCell[] roots = embryo.getRoots();
        int min = embryo.minExpression();
        int max = embryo.maxExpression();
        for (EmbryoCell cell : roots){        
            VerticalTreePanel panel = new VerticalTreePanel(cell,20*cell.getLeafCount(),(float)1.0,400);
            panel.setColorScale(new DefaultColorScale(0,(int)(0.5*embryo.maxExpression())));
            mainPanel.add(panel);
        }
        this.add(scroll);
    }
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {  
                try {
                    MySql db = MySql.getMySql();
                    SeriesEmbryo embryo = new SeriesEmbryo(db,"20120925_aha-1_2_L1","zblot");
                    TreeFrame frame = new TreeFrame(embryo); 
                    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                    frame.setPreferredSize(new Dimension(500,500));
                    frame.pack();
                    frame.setVisible(true);
                } catch (Exception exc){
                    exc.printStackTrace();
                }
            }
        }); 
    }        
}
