/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging.binarytree;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import java.util.List;
import java.awt.Dimension;
/**
 *
 * @author gevirl
 */

public class MultiTreeImage extends VerticalTreeImage {
    /** basisRoot is the root of a subtree that is used as the backbone framework for all the embryos added
    * to this image.  This is typically a root cell of the Sulston embryo. All the added embryo are then
     * mapped to this basisRoot
*/
    public MultiTreeImage(EmbryoCell basisRoot,int height,float timeScale,int labelWidth)throws Exception {
        super("",basisRoot,height,timeScale,labelWidth,Utils.getMaxDepth(basisRoot));
        this.setNodeImage(new MultiNodeImage()); 
    }
    // create the image with an initial list of embryos
    public MultiTreeImage(EmbryoCell basisRoot,List<SeriesEmbryo> embryos,int height,float timeScale,int labelWidth)throws Exception {
        super("",basisRoot,height,timeScale,labelWidth,Utils.getMaxDepth(basisRoot));
        this.setNodeImage(new MultiNodeImage(embryos));    
    }
    public void addEmbryo(SeriesEmbryo embryo){
        ((MultiNodeImage)this.nodeImage).addEmbryo(embryo);
    }

}

