/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.geom.Rectangle2D;
import java.awt.Graphics2D;
import org.rhwlab.db.beans.ChromosomeRegion;
/**
 *
 * @author gevirl
 */
/*
 * 
 * a basic region image that can be draw
 * the label,color height and horizontal scale can be set
 * the chromosome region must also be specified
 */
public class RegionImage {
    public BufferedImage getImage(){
        
        BufferedImage image = new BufferedImage(width,height,BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = image.createGraphics();
        
        g2.setColor(color);
        g2.fillRect(0, 0, width, height);
        
        // find the size of the label
        if (label != null && displayLabel){
            Rectangle2D bounds = g2.getFontMetrics().getStringBounds(label, g2);
        
            // center the label in the colored region
            double x = (width-bounds.getWidth())/2;
            double y = bounds.getHeight()+(height-bounds.getHeight())/2;
            g2.setColor(Color.white);
            g2.drawString(label, (float)x, (float)y);
        }
        return image; 
    }
    public void setLabel(String lab){
        this.label = lab;
    }
    public void setColor(Color c){
        this.color = c;
    }
    public void setHeight(int h){
        this.height = h;
    }
    public void setScale(int s){
        this.scale = s;
        width = (region.getEnd()-region.getStart())/scale;
        if (width == 0) width = 1;
    }
    public void setDisplayLabel(boolean disp){
        this.displayLabel = disp;
    }
    public void setRegion(ChromosomeRegion r){
        this.region = r;
    }
    public int getWidth(){
        return width;
    }
    public int getHeight(){
        return height;
    }
    public ChromosomeRegion getRegion(){
        return region;
    }
    boolean displayLabel = false;
    String label;
    Color color;
    int height;
    int scale;
    int width;
    ChromosomeRegion region;
}
