/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging;

import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.beans.TimePointNucleus;
import org.rhwlab.db.beans.Imaged;

/**
 *
 * @author louis
 */
public class NucLocationTIFF extends TIFF{
    public NucLocationTIFF(SeriesEmbryo embryo,Imaged metaData,String dir) throws Exception {
        super(dir);
        this.embryo = embryo;
        this.zres = metaData.getZPixelsPerPlane();

    }
    // determine the pixel values inside and background for each cell
    public List<ImagePixel> cellPixels(){
        ArrayList<ImagePixel> ret = new ArrayList<ImagePixel>();
        ImagePlus iPlus = ij.IJ.openImage(expressFile.getPath());
        ByteProcessor processor  = (ByteProcessor)iPlus.getProcessor(); 
        int w = processor.getWidth();
        int h = processor.getHeight();
        EmbryoCell[] cells = embryo.getCellsAtTimePlane(time, plane, zres);
        for (EmbryoCell cell : cells){
            ArrayList<Integer> inside = new ArrayList<Integer>();
            ArrayList<Integer> background = new ArrayList<Integer>();
            TimePointNucleus nuc = cell.getNucleusAtTime(time);
            double d = cell.nucDiameter(nuc, plane,zres);
            int x = cell.xAtTime(time);
            int y = cell.yAtTime(time);
            
            // local cell region is a rectangle 2*diameter by 2*diameter centered on the cell
            int firstRow = Math.max(0,(int)(y-d));
            int lastRow = Math.min(h, (int)(y+d));
            int firstCol = Math.max(0, (int)(x-d));
            int lastCol = Math.min(w, (int)(x+d));
            for (int i=firstRow ; i<lastRow ; ++i){
                for (int j=firstCol ; j<lastCol ; ++j){
                    int pixel = processor.get(j,i);
                    // inside??
                    if (insideCellRadius(cell,j,i)){
                        inside.add(new Integer(pixel));
                        
                    }else{
                        if (!insideAnyCell(cells,j,i)){
                            background.add(new Integer(pixel));
                        }
                    }
                }
            }
            System.out.printf("%s: %d,%d\n", cell.getName(),inside.size(),background.size());
            // build pixel value strings
            StringBuilder inBuilder = new StringBuilder();
            boolean first = true;
            for (Integer in : inside){
                if (first){
                    first = false;
                } else {
                    inBuilder.append(",");
                }
                inBuilder.append(in);
            }
            StringBuilder backBuilder = new StringBuilder();
            first = true;
            for (Integer back : background){
                if (first){
                    first = false;
                } else {
                    backBuilder.append(",");
                }
                backBuilder.append(back);
            }  
            ret.add(new ImagePixel(embryo.getID(),cell.getName(),time,plane,inBuilder.toString(),backBuilder.toString()));
        }
        return ret;
    }
    // is the pixel at (x,y) within the radius of the given cell 
    public boolean insideCellRadius(EmbryoCell cell,int pixX,int pixY){
        TimePointNucleus nuc = cell.getNucleusAtTime(time);
        double d = cell.nucDiameter(nuc, plane,zres);
        double r = d/2.0;
        int x = cell.xAtTime(time);
        int y = cell.yAtTime(time); 
        
        double dx = (double)(pixX-x);
        double dy = (double)(pixY-y);
        return dx*dx+dy*dy<=r*r;
    }
    
    public boolean insideAnyCell(EmbryoCell[] cells,int pixX,int pixY){
        for (EmbryoCell cell : cells){
            if (insideCellRadius(cell,pixX,pixY)) return true;
        }
        return false;
    }
    public BufferedImage getImage(Color lineageColor,Color expressColor,int rule){
        BufferedImage image = super.getImage(lineageColor, expressColor, rule);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        annotate(g2);        
        return image;
    }    
    @Override
    public BufferedImage getImage(boolean lineaging,boolean expression){
        BufferedImage image = super.getImage(lineaging, expression);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        annotate(g2);

        return image;
    } 
    private void annotate(Graphics2D g2){
        // annotate with the nuclei locations using the embryo
        EmbryoCell[] cells = embryo.getCellsAtTimePlane(time, plane, zres);
        for (EmbryoCell cell : cells){
            TimePointNucleus nuc = cell.getNucleusAtTime(time);
            double d = cell.nucDiameter(nuc, plane,zres);
            double r = d/2.0;
            int x = cell.xAtTime(time);
            int y = cell.yAtTime(time);
            Ellipse2D.Double circle = new Ellipse2D.Double(x-r,y-r,d,d);
            if (radius) g2.draw(circle);
            if (label) g2.drawString(cell.getName(), x, y);
            // add label and radius for this cell if an annotation
            if (annotations.contains(cell.getName())){
                g2.draw(circle);
                g2.drawString(cell.getName(), x, y);
            }
        }        
    }
    public void setAppearance(boolean label,boolean radius){
        this.label = label;
        this.radius = radius;
    }
    public void annotate(String cellName){
        annotations.add(cellName);
    }
    public void clearAnnotations(){
        annotations.clear();
    }
    public double getZRes(){
        return this.zres;
    }
    TreeSet<String> annotations = new TreeSet<String>();
    boolean label=false; // label all cells with id
    boolean radius=false;  // put radius around all cells
    SeriesEmbryo embryo;
    double zres = 1.0/0.09;
}
