/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.imaging;
import org.rhwlab.db.beans.*;
import java.awt.*;
import java.awt.image.*;
import java.util.*;
import java.awt.image.AffineTransformOp;
import java.awt.geom.AffineTransform;
/**
 *
 * @author gevirl
 */
/* draw the gene region with exons and intron
 * this includes a list of exons which are RegionImage objects
 * the color,height,and scale can be set
 * the label is taken from the Gene object used to define a GeneRegionImage object
 * the exons do not have a label
 */
public class GeneRegionImage {
    public GeneRegionImage(Gene gene){
        this.gene = gene;
        GeneRegion geneRegion = gene.getRegion();
        exonRegions = new ArrayList<RegionImage>();
        for (Exon exon : gene.getExons()){
            RegionImage regionImage = new RegionImage();
            regionImage.setRegion(new ChromosomeRegion(geneRegion.getChromosome(),exon.getStart(),exon.getEnd()));
            exonRegions.add(regionImage);
        }
    }
    public BufferedImage getImage(){
        BufferedImage image = new BufferedImage(width,height,BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = image.createGraphics();
        
        g2.setColor(g2.getBackground());
        g2.fillRect(0, 0, width, height);
        
        // put in each exon region
        for (RegionImage exonImage : exonRegions){
            int pos = (exonImage.getRegion().getStart() - gene.getRegion().getStart())/scale;
            g2.drawImage(exonImage.getImage(),new AffineTransformOp(new AffineTransform(),AffineTransformOp.TYPE_NEAREST_NEIGHBOR),pos,0);
        }
        return image;
    }
    public void setColor(Color c){
        this.color = c;
        for (RegionImage image : exonRegions) {
            image.setColor(c);
        }
    }
    public void setHeight(int h){
        this.height = h;
        for (RegionImage image : exonRegions) {
            image.setHeight(h);
        }
    }
    public void setScale(int s){
        this.scale = s;
        width = (gene.getRegion().getEnd()-gene.getRegion().getStart())/scale;
        if (width == 0) width = 1;
        
        for (RegionImage image : exonRegions) {
            image.setScale(s);
        }        
    }
    public int getWidth(){
        return width;
    }
    Color color;
    int scale;
    int width;
    int height;
    Gene gene;
    ArrayList<RegionImage> exonRegions;
}
