/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.genemodel;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.TreeMap;

/**
 *
 * @author gevirl
 */
public class GenomeSequence {
    File fastA;
    TreeMap<String,String> genome= new TreeMap<>();
    
    public GenomeSequence(String file)throws Exception {
        fastA = new File(file);
        // read the genome 
        StringBuilder builder = null;
        String chromo = null;
        BufferedReader reader = new BufferedReader(new FileReader(fastA));
        String line = reader.readLine();
        while (line != null){
            if (line.length()>0){
                if (line.charAt(0)=='>'){
                    if (builder != null){
                        this.genome.put(chromo,builder.toString());
                    }
                    builder = new StringBuilder();
                    String[] tokens = line.split(" ");
                    chromo = tokens[0].substring(1);
                } else {
                    builder.append(line.toUpperCase());
                }
            }
            line = reader.readLine();
        }
        this.genome.put(chromo,builder.toString());    
        
        for (String key : genome.keySet()){
            System.out.printf("%s - %d\n",key,genome.get(key).length());
        }
    }
    public String getExonSequence(List<Annotation> exons){

        String genomeSequence = genome.get(exons.get(0).getChromosome());  // sequence of the chromosome
        StringBuilder builder = new StringBuilder();

        for (Annotation exon : exons){
            String seq = genomeSequence.substring(exon.start-1, exon.end);
            builder.append(seq);
        }
        String ret = builder.toString();

        return ret;            
    } 
    
    public String getSequence(String chromo,int start,int end){
        String chromoSeq = this.genome.get(chromo);
        if (chromoSeq != null){
            return chromoSeq.substring(start-1,end);
        }
        return null;
    }
    public TreeMap<String,Integer> getChromosomeSizes(){
        TreeMap<String,Integer> ret = new TreeMap<>();
        for (String chromo : this.genome.keySet()){
            ret.put(chromo, this.genome.get(chromo).length());
        }
        return ret;
    }
    static public void main(String[] args)throws Exception {
        GenomeSequence seq = new GenomeSequence("/net/waterston/vol9/References/WS245/c_elegans.PRJNA13758.WS245.genomic.renamed.fa");
        int hdfs=0;
    }
}
