/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.gene.model.exons;

/**
 *
 * @author gevirl
 */
public class JensenShannon {
    static public double compute(double[][] x) {
        int n = x[0].length;
        double[][] p = new double[x.length][];
        for (int i=0 ; i<p.length ; ++i){
            p[i] = normalize(x[i]);
        }
        
        double[] avg = new double[n];
        for (int i=0 ; i<n ; ++i){
            avg[i] = p[0][i];
            for (int j=1 ; j<p.length ; ++j){
                avg[i] = avg[i] + p[j][i];
            }
            avg[i] = avg[i]/p.length;
        }
        
        double sum = 0.0;
        for(int i=0 ; i<p.length ; ++i){
            sum = sum + entropy(p[i]);
        }
        sum = sum/p.length;
        
        double avgH = entropy(avg);
        if (avgH < sum){
            int aisdhfsd=0;
        }
        return avgH - sum;
        
    }
    
    static double entropy(double[] p){
        double e=0.0;
        for (int i=0 ; i<p.length ; ++i){
            if (p[i] > 0.0){
                e = e - p[i]*Math.log(p[i]);
            }
        }
        return e;
    }
    static double[] normalize(double[] x){
        double[] r = new double[x.length];
        
        double sum = 0.0;
        for (int i= 0 ; i<x.length ; ++i){
            sum = sum + x[i];
        }
        if (sum > 0.0){
            for (int i= 0 ; i<x.length ; ++i){
                r[i] = x[i]/sum;
            }  
        }
        return r;
    }  
    
    // order the genes by js divergence
    static public void main(String[] args){
        
    }
}
