/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.freechart;

import java.util.Map.Entry;
import java.util.TreeMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/**
 *
 * @author gevirl
 */
public class CummDistPanel extends ChartPanel {
    boolean logX = false;
    int nBins = 100;
    
    public CummDistPanel() {
        super(null);
    }
    
    public void display(TreeMap<Object,Integer> data,String xLabel,String title){
    
        // bin the values
        double s = asDouble(data.firstKey());
        double e = asDouble(data.lastKey());
        double d = (e-s)/nBins;
        int[] binCounts = new int[nBins];
        for (Entry entry : data.entrySet()){
            double x = asDouble(entry.getKey());
            int count = (Integer)entry.getValue();
            int bin = Math.min((int)((x - s)/d),nBins-1);
            binCounts[bin] = binCounts[bin] + count;
        }
        
        // accumulate the bins
        for (int b =1 ; b<nBins ; ++b){
            binCounts[b] = binCounts[b] + binCounts[b-1];
        }
        
        // make the plot
        XYSeries series = new XYSeries(xLabel);
        double x = s+d/2;
        for (int b=0 ; b<nBins ; ++b){
            series.add(x, binCounts[b]);
            x = x + d;
        }
        XYSeriesCollection collect = new XYSeriesCollection(series);
        
        JFreeChart chart = ChartFactory.createXYLineChart(title, xLabel, "Counts", collect, PlotOrientation.VERTICAL, false,false,false);
        this.setChart(chart);
    }
    public void setLogX(boolean b){
        this.logX = b;
    }
    private Double asDouble(Object o){
        if (o instanceof Double){
            if (logX){
                return Math.log10(1.0+(Double)o);
            }
            return (Double)o;
        } else if (o instanceof Integer){
            if (logX){
                return Math.log10(1.0+((Integer)o).doubleValue());
            }
            return ((Integer)o).doubleValue();
        }
        return null;
    }
    static public void main(String[] args){
        CummDistPanel panel = new CummDistPanel();
        int oiasdfioj=0;
    }
}
