/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.formats;
import java.io.*;
import java.net.URL;
import java.util.zip.*;
import java.util.*;
import org.rhwlab.beans.SeriesMetaData;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class Zip implements Runnable { 
    public Zip(String name,List<File> files) throws Exception {
        this(name);
        this.dirs = files;
        this.urls = null;
    }
    
    public Zip(String name,Map<String,URL> urls)throws Exception {
        this(name);
        this.urls = urls;
        this.dirs = null;
    }
    private Zip(String name)throws Exception {
        this.name = name;
        pipeStream = new PipedOutputStream();
        zipOut = new ZipOutputStream(pipeStream);
        pipeIn = new PipedInputStream(pipeStream);        
    }

    // add recursively the contents of the directories to the zip and add the urls
    public void run()  {
        try {
            if (dirs != null){
                for (File dir : dirs){
                    if (dir.isDirectory()) {
                        addDirectory(dir,dir.getName());
                    }else {
                        addFile(dir,dir.getParentFile().getName());
                    }
                }
            }
            if (urls != null){
                for (String urlName : urls.keySet()){
                    addUrl(urlName,urls.get(urlName));
                }
            }
            zipOut.close();
        }catch (Exception exc){
            exc.printStackTrace();
        }

    }
    private void addDirectory(File directory,String prefix)  {
        // get a list of files in the directory
        File[] files = directory.listFiles();
        try {        
            for (int i=0 ; i<files.length ; ++i){
                if (!files[i].isDirectory()){
                    addFile(files[i],prefix);

                } else {
                    addDirectory(files[i],prefix+"/"+files[i].getName());
                }

            }
        } catch (Exception exc){
            exc.printStackTrace();
        }        
    }
    private void addFile(File file,String prefix) throws Exception{
        byte[] data = new byte[BUFFER];
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file));
        String zipName = prefix+"/"+file.getName();
        ZipEntry entry = new ZipEntry(zipName);
        zipOut.putNextEntry(entry);
        int n;
        while ((n=inStream.read(data, 0, BUFFER))!=-1){
            zipOut.write(data, 0, n);
        }
        inStream.close();        
    }

    private void addUrl(String urlName,URL url)throws Exception {
        byte[] data = new byte[BUFFER];
        BufferedInputStream inStream = new BufferedInputStream(url.openStream());
        ZipEntry entry = new ZipEntry(urlName);
        zipOut.putNextEntry(entry);    
        int n;
        n=inStream.read(data, 0, BUFFER);
        while (n !=-1){
            zipOut.write(data, 0, n);
            n=inStream.read(data, 0, BUFFER);
            int uiasdfuihs=0;
        }
        inStream.close();         
    }
    public InputStream getInputStream() throws Exception {
        return pipeIn;
    }
    public String getName(){
        return name;
    }
   
    // zip a all the images and annotations of a set of series
    public static void main(String[] args){
        
        try {
            // compile a list of directories to zip
            
            for (String series : args){
                ArrayList<File> dirList = new ArrayList<File>();
                SeriesMetaData md = new SeriesMetaData(MySql.getMySql(),series);
                dirList.add(new File(md.getAnnotsDir()));
                dirList.add(new File(md.getImageDir()));
            
            
                String outFile = series+".zip";
                Zip zip = new Zip(outFile,dirList);
                new Thread(zip).start();


                InputStream stream = zip.getInputStream();

                FileOutputStream outStream = new FileOutputStream(new File(outFile));
                int n;
                byte[] data = new byte[BUFFER];
                while ((n=stream.read(data,0,BUFFER))!=-1){
                     outStream.write(data, 0, n);
                
                }
                outStream.close();
            }
            
        }catch (Exception exc){
            exc.printStackTrace();
        }
    }
      
     
    static final int BUFFER = 2048;
    String name;
    List<File> dirs;
    Map<String,URL> urls;
    PipedOutputStream pipeStream;
    PipedInputStream pipeIn;
    ZipOutputStream zipOut;
}
