/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression.image;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.rhwlab.imaging.binarytree.AnnotationImage;
import org.rhwlab.beans.EmbryoCell;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;


/**
 *
 * @author gevirl
 */
// class to draw a given subtree (root)
// must be set prior to getting the image:
//  1) dimension
//  2) root 
//  3) line image object (object that renders the line)
//  annotations can be added to the image
abstract public class TreeImage {
    public BufferedImage getImage() {
        image = new BufferedImage(dim.width,dim.height,BufferedImage.TYPE_INT_ARGB);
        int treeWidth = dim.width-100;
        g2 = image.createGraphics();
        g2.setBackground(Color.WHITE);
        g2.clearRect(0, 0, dim.width, dim.height);        
        maxTime = root.maxEndTime(); 
//        timeScale = (float).9*(float)dim.width/(float)maxTime;
        timeScale = (float)treeWidth/(float)maxTime;
        // put the rate scale on the top
//        BufferedImage rateScale = OnsetRateScale.getImage();
//        g2.drawImage(rateScale,0,0, null); 
        
        // draw the tree 
        int st = root.getStartTime();
        drawCell(root,root.getStartTime()*timeScale,0,dim.width,dim.height-10);
        
        // put a time scale on the bottom
        for (int t=0 ; t<maxTime ; t=t+25){
            float p = (float)t*timeScale;
            g2.setColor(Color.BLACK);
            g2.drawString(Integer.toString(t), p, dim.height);
        }     
        g2.drawString(Integer.toString(maxTime), maxTime*timeScale, dim.height);
        
        
        // draw the annotations
        for (AnnotationImage annotation : annotations){
            annotation.drawAnnotation(g2);
        }
        return image;
    }
    
    // draw the subtree of the given cell in a rectangle 
    private float drawCell(EmbryoCell cell,float x0,float y0,float x1,float y1){
        if (cell.getName().equals("Dpppp")){
            int saudfhuisd=0;
        }
        float dy = y1 - y0;
        Stroke save = g2.getStroke();
        BasicStroke wide = new BasicStroke(3);
//        System.out.printf("Cell: %s,x=%f,y=%f\n",cell.getName(),x,y);
        
        // get the length of time for this cell, draw horizontal line
        int startTime = cell.getStartTime();
        float time = cell.getEndTime()-startTime+1;
        float xs = x0;
        float xe = xs+ time*timeScale;
        float y = y0 + dy/2;
        Color col = cellLineImage.drawHorizontal(cell, xs, xe, y, g2);
        lineLocs.put(cell.getName(),cellLineImage.getBoundingRectangle());
/*        
        // is there an onset in this cell?
        CellDataTimeSeries cdts = cell.getExpTimeSeries();
        ExpressionOnset onset = cdts.getExprOnset();
        if (onset != null){
            double rate = onset.getRate();
            // label this cell
            g2.setColor(Color.BLACK);
            g2.drawString(cell.getName(),xs, y);

            float xmid = xs + (onset.getOnset()-startTime)*timeScale;
            g2.setColor(col);
            
            g2.setStroke(wide);
            Line2D line = new Line2D.Float(xs,y,xmid,y);
            g2.draw(line);
            
            col = OnsetRateScale.getColor(rate);
            g2.setColor(col);
            line = new Line2D.Float(xmid,y,xe,y);
            g2.draw(line);
            g2.setStroke(save);
        } else {
        // draw horizontal line for this cell
            g2.setStroke(wide);;
            g2.setColor(Color.BLACK);
            g2.drawString(Integer.toString(startTime),xs, y);
        
            Line2D line = new Line2D.Float(xs,y,xe,y);
            g2.setColor(col);
            g2.draw(line);
            g2.setStroke(save);
        }
 */       
        // draw the children cells
        int n = cell.getChildCount();
        if (n >0 ){
        
            // determine the two rectangles to use for the children
            EmbryoCell childUp = (EmbryoCell)cell.getChildAt(0);
            EmbryoCell childDn = (EmbryoCell)cell.getChildAt(1);
            /*
            if (childUp.getName().compareTo(childDn.getName())< 0){
                EmbryoCell saveCell = childUp;
                childUp = childDn;
                childDn = saveCell;
            }
            */
            float leavesUp = childUp.getLeafCount();
            
            float leavesDn = childDn.getLeafCount();
            float ym = y0+dy*(leavesUp/(leavesUp+leavesDn));
        
            float upMid = drawCell(childUp,xe,y0,x1,ym);
            
            // draw the vertical lines
            g2.setStroke(wide);
            g2.setColor(col);
            g2.draw(new Line2D.Float(xe,ym,xe,upMid));
            g2.setStroke(save);
            float dnMid = drawCell(childDn,xe,ym,x1,y1);
            g2.setColor(col);
            g2.setStroke(wide);
            g2.draw(new Line2D.Float(xe,ym,xe,dnMid));
            g2.setStroke(save);
        } else {
            // draw the cell label
            g2.setColor(Color.BLACK);
            g2.drawString(cell.getName(),xe, y);
            // save the location of the cell name string in the image
            Rectangle2D r = g2.getFont().getStringBounds(cell.getName(),g2.getFontRenderContext());
            r.setRect(r.getX()+xe, r.getY()+y, r.getWidth(), r.getHeight());
            leafLocs.put(cell.getName(),r);
        }
        return y;
      
    }    
    // finds the leaf string printed at location x,y - used for interpreting mouse clicks
    public String getLeafAt(int x,int y){
        for (String leaf : leafLocs.keySet()){
            Rectangle2D rect = leafLocs.get(leaf);
            if (rect.contains((double)x, (double)y)){
                return leaf;
            }
        }
        return null;
    }
    public String getCellAt(int x,int y){
        for (String cell : lineLocs.keySet()){
            Rectangle2D rect = lineLocs.get(cell);
            if (rect.contains((double)x, (double)y)){
                return cell;
            }            
        }
        return null;
    }
    public String getClosestCellTo(int x,int y){
        String closest = null;
        double dist= Double.MAX_VALUE;
        
        for (String cell : lineLocs.keySet()){
            Rectangle2D rect = lineLocs.get(cell);
            if (rect.contains((double)x, (double)y)){
                closest = cell;
                break;
            } else if (rect.getMinX()<=x && x<=rect.getMaxX()) {
                double d = Math.min(Math.abs(rect.getMaxY()-y), Math.abs(rect.getMinY()-y)); // the minimum distance to the rectangle
                if (d < dist){
                    closest = cell;
                    dist = d;
                }
            }           
        }
        if (closest == null){
            closest = getClosestLeaf(y);
        }
        return closest;
    }
    public String getClosestLeaf(int y){
        String closest = null;
        double dist = Double.MAX_VALUE;

        for (String cell : leafLocs.keySet()){
            Rectangle2D rect = leafLocs.get(cell);
                double d = Math.min(Math.abs(rect.getMaxY()-y), Math.abs(rect.getMinY()-y)); // the minimum distance to the rectangle
                if (d < dist){
                    closest = cell;
                    dist = d;
                }            
        }
         return closest;
    }
    public int getTimeAt(int x){
        return (int)(x/timeScale);
    }
    public void setDimension(Dimension d){
        dim = d;
    }
    public void setRoot(EmbryoCell r){
        root = r;
    }
    public void setLineImage(CellLineImage lineImage){
        cellLineImage = lineImage;
    }
    public void addAnnotation(AnnotationImage annotation){
        annotations.add(annotation);
    }
    public String getFirstLeaf(){
        double yMin = Double.MAX_VALUE;
        String first = null;
        for (String leaf : leafLocs.keySet()){
            Rectangle2D rect = leafLocs.get(leaf);
            if (rect.getY() < yMin){
                yMin = rect.getY();
                first = leaf;
            }
        }
        return first;
    }
    abstract public void setScale(int min,int max);
   
    Graphics2D g2;
    float timeScale;
    int maxTime;
    EmbryoCell root;  // the root of the tree to draw in the buffered image
    BufferedImage image;
    Dimension dim;
    TreeMap<String,Rectangle2D> leafLocs= new TreeMap<String,Rectangle2D>(); // keeping track of the locations of the leaf labels
    HashMap<String,Rectangle2D> lineLocs = new HashMap<String,Rectangle2D>(); // recording the locations of the cell horizontal lines
    CellLineImage cellLineImage;  // the object that draw the horizontal line for the cell
    ArrayList<AnnotationImage> annotations = new ArrayList<AnnotationImage>();
}
