/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression.image;
import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;
/**
 *
 * @author gevirl
 */
public class OnsetRateScale {
    static public Color getColor(double r){
        int index = (int)(r/delta);
        if (index >= colors.length) index = colors.length-1;
//System.out.printf("Rate =%f, index=%d\n",r,index);        
        return colors[index];
    }
    static BufferedImage getImage(){
        BufferedImage image = new BufferedImage(100,100,BufferedImage.TYPE_INT_ARGB); 
        Graphics2D g2 = image.createGraphics();
        Stroke save = g2.getStroke();
        BasicStroke wide = new BasicStroke(3);
        String scaleStr = "Onset Rate Scale";

        Rectangle2D bounds = g2.getFontMetrics().getStringBounds(scaleStr, g2);
        
        image = new BufferedImage((int)bounds.getWidth(),(int)bounds.getHeight()*(colors.length+2),BufferedImage.TYPE_INT_ARGB);
        g2 = image.createGraphics();
        g2.setColor(Color.BLACK);
        int h = (int)bounds.getHeight();
        float w = (float)bounds.getWidth();
        g2.drawString(scaleStr,0,h);
        for (int i=0 ; i<colors.length ; ++i){
            g2.setColor(Color.BLACK);
            String s = Integer.toString((int)delta*i);
            bounds = g2.getFontMetrics().getStringBounds(s, g2);
            h = h + (int)bounds.getHeight();
            g2.drawString(s,0,h);

            g2.setColor(colors[i]);
            g2.setStroke(wide);
            g2.draw(new Line2D.Float((float)bounds.getWidth(),(float)h,w,(float)h));
            g2.setStroke(save);
        }
        return image;
    }
    static Color[] colors = {Color.BLUE,Color.GREEN,Color.YELLOW,Color.CYAN,Color.MAGENTA,Color.ORANGE,Color.RED};
    static double delta = 500.0;
}
