/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression.image;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.expression.ExpressionOnset;
import java.awt.*;
import java.awt.geom.*;

/**
 *
 * @author gevirl
 */
public class OnsetLineImage implements CellLineImage {
    public Color drawHorizontal(EmbryoCell cell,float x0,float x1,float y,Graphics2D g2){
        Color color = Color.BLACK;
        Stroke save = g2.getStroke();
        Stroke stroke = new BasicStroke(lineWidth);
        g2.setStroke(stroke);
        
        // find the cell that has the onset
        EmbryoCell onsetCell = cell.getOnsetCell();
        if (onsetCell == null){
            // the cell to draw is before any onsets      
            Line2D line = new Line2D.Float(x0,y,x1,y);
            g2.setColor(color);
            g2.draw(line);
        } else {
            ExpressionOnset onset = onsetCell.getExpTimeSeries().getExprOnset();
            int start = onsetCell.getStartTime();
            int end = onsetCell.getEndTime();
            if (onsetCell.getName().equals(cell.getName())){
                // the cell to draw is the onset cell
                float xmid = x0 + (onset.getOnset()-start)*(x1-x0)/(end-start);
                Line2D line = new Line2D.Float(x0,y,xmid,y);
                g2.setColor(color);
                g2.draw(line); 
                
                line = new Line2D.Float(xmid,y,x1,y);
                color = OnsetRateScale.getColor(onset.getSlope());
                g2.setColor(color);
                g2.draw(line);                
            
            } else {
                // the cell to draw is a descendent of the onset cell
                color = OnsetRateScale.getColor(onset.getSlope());
                Line2D line = new Line2D.Float(x0,y,x1,y);
                g2.setColor(color);
                g2.draw(line);
            }
        }
        rect = new Rectangle2D.Float(x0,y-1,x1-x0,lineWidth+2);
        g2.setStroke(save);
        return color;
    }
    public void setLineWidth(int w){
        lineWidth = w;
    }
    public Rectangle2D getBoundingRectangle(){
        return rect;
    }
    public void setRange(int min,int max){
        
    }
    int lineWidth=3;
    Rectangle2D rect;
}
