/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression.image;
import java.awt.image.BufferedImage;
import java.awt.*;
import java.awt.geom.*;
import org.rhwlab.beans.*;
import java.util.*;
import org.rhwlab.db.MySql;
import java.awt.event.MouseEvent;
/**
 *
 * @author gevirl
 */
public class CummExpImage {
    public CummExpImage(){
        clear();
    }
    final public void clear(){
        exps = new HashMap<String,CummulativeExpression[]>();
        elipses = new HashMap<String,ArrayList<Ellipse2D>>();
        labels = new ArrayList<ImageLabel>();
        exprArrays = new HashMap<String,Expression[]>();
        lowers = new   HashMap<String,Expression[]>();
        uppers = new   HashMap<String,Expression[]>(); 
        maxExprs.put(embryoLabel, 0.0);
        scales.put(embryoLabel, 0.5);        
    }
    public BufferedImage getImage(){
        image = new BufferedImage(dim.width,dim.height,BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = image.createGraphics();
        
        g2.setColor(Color.BLACK);
        int bottom = dim.height-80;
        
        // find the maximum time in all the embryos
        double maxTime=720;
        for (CummulativeExpression[] expArray : exps.values()){
            double time = expArray[expArray.length-1].getTime();
            if (time > maxTime) maxTime = time;
        }
        
        double xScale = (double)(dim.width-50)/(double)maxTime;
        double expScale = scales.get(embryoLabel);
        double maxExp = maxExprs.get(embryoLabel);
        for (String series : exps.keySet()){
            CummulativeExpression[] expArray = exps.get(series);
            CummulativeExpression exp = expArray[0];
            ArrayList<Ellipse2D> elipseList = new ArrayList<Ellipse2D>();
            elipses.put(series, elipseList);
            double x0 = exp.getTime()*xScale;
            double y0 = bottom*(1-(exp.getExpression()/maxExp)*(expScale)); 
            double radius = 6.0;
            Ellipse2D e = new Ellipse2D.Double(x0,y0,radius,radius);
            elipseList.add(e);
            g2.draw(e);            
            for (int i=1 ; i< expArray.length ; ++i){
                exp = expArray[i];
                double x1 = exp.getTime()*xScale;
                double y1 = bottom*(1-(exp.getExpression()/maxExp)*(expScale));

                Line2D.Double line = new Line2D.Double(x0,y0,x1,y1);
                g2.draw(line);
                radius = 6.0;
                e = new Ellipse2D.Double(x1,y1,radius,radius);
                elipseList.add(e);
                g2.draw(e);
                x0 = x1;
                y0 = y1;
            }

        }
        
        // label the x-axis
        int time=0;
        while (time <= maxTime){
            double x = time*xScale;
            g2.drawString(Integer.toString(time),(float)x, bottom+40);
            time = time + 20;
        }
        if (this.xaxisLabels != null){
            for (int i=0 ;i<this.xaxisLabels.length ; ++i){
                double x = this.labelTimes[i]*xScale;
                g2.drawString(this.xaxisLabels[i],(float)x, bottom+80);                
            }
        }
        
        // add the image data labels
        for (ImageLabel label : labels){
            ArrayList<Ellipse2D> es = elipses.get(label.text);
            Ellipse2D e = es.get(label.index);
            g2.drawString(label.text, (float)e.getCenterX(), (float)e.getCenterY());
        }
        
        // draw the other expression arrays
        for (String expLabel : exprArrays.keySet()){
            Expression[] expArray = exprArrays.get(expLabel);
            double eScale = scales.get(expLabel);
            double mExp = maxExprs.get(expLabel);
            
            double x0 = expArray[0].getTime()*xScale;
            double y0 = bottom*(1.0 - expArray[0].getValue()*eScale/mExp);
            g2.setColor(colors.get(expLabel));
            for (int i=1 ; i<expArray.length ; ++i){
                double x1 = expArray[i].getTime()*xScale;
                double y1= bottom*(1.0 - expArray[i].getValue()*eScale/mExp);
                Line2D.Double line = new Line2D.Double(x0,y0,x1,y1);
                g2.draw(line);  
                x0 = x1;
                y0 = y1;
            }
        }
        
        // draw any credible intervals
        for (String expLabel : lowers.keySet()){
            double eScale = scales.get(expLabel);
            double mExp = maxExprs.get(expLabel);            
            Expression[] upper = uppers.get(expLabel);
            Expression[] lower = lowers.get(expLabel);
            Polygon poly = new Polygon();
            for (int i=0 ; i<upper.length ; ++i){
                double x = upper[i].getTime()*xScale;
                double y = bottom*(1.0 - upper[i].getValue()*eScale/mExp);
                poly.addPoint((int)x,(int)y);
            }
            for (int i=lower.length-1 ; i>=0 ; --i){
                double x = lower[i].getTime()*xScale;
                double y = bottom*(1.0 - lower[i].getValue()*eScale/mExp);
                poly.addPoint((int)x,(int)y);
            }  
            Composite originalComposite = g2.getComposite(); 
            g2.setComposite(makeComposite((float)0.1));    
            g2.setPaint(colors.get(expLabel));
            g2.fill(poly);
            g2.setComposite(originalComposite);
            
        }
        return image;
    }
    private AlphaComposite makeComposite(float alpha) {
        int type = AlphaComposite.SRC_OVER;
        return(AlphaComposite.getInstance(type, alpha));
    }
    
    public void addExpression(String label,Expression[] expArray,Color color){
        exprArrays.put(label, expArray);
        
        // get the max
        double m = 0.0;
        for (int i=0 ; i<expArray.length ; ++i){
            if (expArray[i].getValue() > m) m=expArray[i].getValue();
        }
        maxExprs.put(label, new Double(m));
        colors.put(label, color);
    }
    public void addConfidenceInterval(String label,Expression[] lower,Expression[] upper){
        this.uppers.put(label, upper);
        this.lowers.put(label, lower);
    }
    public double getMaxExp(String label){
        return maxExprs.get(label);
    }
    public void setScale(String label,double scale){
        scales.put(label,new Double(scale));
    }
    public void addEmbryo(MySql db,SeriesEmbryo e) {
        SeriesEmbryo embryo = e;
        int time = timeInc;
        double maxEmbExp = maxExprs.get(embryoLabel);
        ArrayList<CummulativeExpression> expList = new ArrayList<CummulativeExpression>();
        while (time <= embryo.getEndTime()){
            
            CummulativeExpression cumm = embryo.totalExpression(db,time);
            
            if (cumm.getExpression() > maxEmbExp) maxEmbExp = cumm.getExpression();
            expList.add(cumm);
            time = time + timeInc;
        }
        maxExprs.put(embryoLabel, maxEmbExp);
        CummulativeExpression[] expArray = expList.toArray(new CummulativeExpression[0]);
        exps.put(embryo.getID(), expArray);
    }
    public void setDimension(Dimension d){
        this.dim = d;
    }
    public ImageLabel getSeriesAt(double x,double y,MouseEvent event){
        for (String series : elipses.keySet()){
            ArrayList<Ellipse2D> elipseList = elipses.get(series);
            for (int i=0 ; i<elipseList.size();++i){
                Ellipse2D e = elipseList.get(i);
                if (e.contains(x,y)){
                    return new ImageLabel(series,i,event);
                }
            }
        }
        return null;
    }
    
    public void addLabel(ImageLabel label){
        labels.add(label);
    }

    public String getEmbryoLabel(){
        return this.embryoLabel;
    }

    public void setXaxisLabels(String[] ls,int[] ts){
        this.xaxisLabels = ls;
        this.labelTimes = ts;
    }
    String[] xaxisLabels;
    int[] labelTimes;
    ArrayList<ImageLabel> labels;
    HashMap<String,ArrayList<Ellipse2D>> elipses;   
    HashMap<String,CummulativeExpression[]> exps;    // the image data cummulative expressions, indexed by series
    HashMap<String,Expression[]> exprArrays;         // the rnaseq expression data, indexed by some label (eg raw,stagedVer1,...)
    HashMap<String,Expression[]> lowers;        // the confidence interval lower bounds for each expression array
    HashMap<String,Expression[]> uppers;        // the confidence interval upper bounds for each expression array
    HashMap<String,Double> scales = new HashMap<String,Double>();  // the vertical scale factor for each expression array
    HashMap<String,Double> maxExprs = new HashMap<String,Double>();   // the maximum expression value
    HashMap<String,Color> colors = new HashMap<String,Color>();   // the color used to draw the expression array
    String embryoLabel = "Embryo Imaging";   // the label used in the above 3 hashes for the imaged expression data
    Dimension dim; // the size of the buffered image
    int timeInc = 10;
    BufferedImage image;

}
