/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.sql.ResultSet;
import java.util.HashMap;
import org.rhwlab.db.MySql;

/**
 *
 * @author gevirl
 */
public class ExpressionWindow {
    public ExpressionWindow(){
        
    }
    public ExpressionWindow(int start,float startSlope,int end,float endSlope,float base,float mean){
        this.start = start;
        this.startSlope = startSlope;
        this.end = end;
        this.endSlope = endSlope;
        this.base = base;
        this.mean = mean;
        
    }
    // remove all the windows for a given series
    static public void removeFromDB(String series)throws Exception {
        String sql = String.format("Delete from ExpressionWindows where Series = \'%s\'",series);
        MySql.getMySql().execute(sql);
    }
    // read all the windows for a series
    static public HashMap<String,ExpressionWindow> getFromDB(String series) throws Exception {
        MySql db = MySql.getMySql();
        HashMap<String,ExpressionWindow> ret = new HashMap<String,ExpressionWindow>();
        String sql = String.format("select * from ExpressionWindows where Series=\'%s\'",
                series);
        ResultSet rs = db.execute(sql);
        while (rs.next()){
            ExpressionWindow eo = new ExpressionWindow();
            eo.initFrom(rs);
            ret.put(eo.leaf, eo);
        }
        return ret;
    }    
    // save this expresison window to the database
    public void saveToDB() throws Exception {
        MySql db = MySql.getMySql();
        // is this a new record
        String sql = String.format("select * from ExpressionWindows where Series=\'%s\' and Leaf=\'%s\'",this.series,this.leaf);
        ResultSet rs = db.execute(sql);
        if (!rs.first()){
            // add the new record
            sql = String.format("Insert into ExpressionWindows (Series,Leaf) values (\'%s\',\'%s\')",this.series,this.leaf);
            db.execute(sql);            
        } 
        //update the data
        sql = String.format("Update ExpressionWindows set Confidence=%f,StartIndex=%d,StartTime=%f,StartSlope=%f,Date=NOW(),Base=%f,EnteredBy=\'%s\',ExpressionType=\'%s\',Cell=\'%s\',"+ 
                    "EndIndex=%d,EndTime=%f,EndSlope=%f,MeanExp=%f" +
                    " where Series=\'%s\' and Leaf=\'%s\'",
                    confidence,start,sulstonStart,startSlope,base,method,type,startCell,end,sulstonEnd,endSlope,mean,series,leaf);
        db.execute(sql);          
    }
    // initialize the values in this expression window from the ResultSet
    public void initFrom(ResultSet rs) throws Exception {
        this.series = rs.getString("Series");
        this.startCell = rs.getString("Cell"); 
        this.method = rs.getString("EnteredBy");
        this.start = rs.getInt("StartIndex");
        this.sulstonStart = rs.getFloat("StartTime");
        this.startSlope = rs.getFloat("StartSlope");
        this.end = rs.getInt("EndIndex");
        this.sulstonEnd = rs.getFloat("EndTime");
        this.endSlope = rs.getFloat("EndSlope");        
        this.mean = rs.getFloat("MeanExp");
        this.base = rs.getFloat("Base");
        this.type = rs.getString("ExpressionType")   ;
        this.leaf = rs.getString("Leaf");
        this.confidence = rs.getFloat("Confidence");        
    }
    public int getStart(){
        return this.start;
    }
    public float getStartSlope(){
        return this.startSlope;
    }
    public int getEnd(){
        return this.end;
    }
    public float getEndSlope(){
        return endSlope;
    }
    public float getBase(){
        return this.base;
    }
    public float getMean(){
        return this.mean;
    }
    
    public void setSeries(String s){
        this.series = s;
    }
    public void setCell(String s){
        this.startCell = s;
    }
    public void setMethod(String s){
        this.method = s;
    }
    public void setLeaf(String s){
        this.leaf = s;
    }
    public void setType(String s){
        this.type = s;
    }
    public void setConfidence(float c){
        this.confidence = c;
    }
    public void setSulstonStart(float t){
        this.sulstonStart = t;
    }
    public void setSulstonEnd(float t){
        this.sulstonEnd = t;
    } 
    
    public Point2D.Float[] getCorners(){
        Point2D.Float[] corners = new Point2D.Float[4];
        corners[0] = new Point2D.Float(start,base); 
        corners[3] = new Point2D.Float(end,base);
       
        double T = (startSlope*start+endSlope*end)/(startSlope+endSlope);
        double f = startSlope*(T-start);
        if (f <= mean){
            corners[1] = new Point2D.Float(start+mean/startSlope,(float)f);
            corners[2] = corners[1];
        } else {
            corners[1] = new Point2D.Float(start+mean/startSlope,mean);
            corners[2] = new Point2D.Float(end-mean/endSlope,mean);
        }
        
        return corners;
    }
    
    String series;
    String startCell;    // the cell in the embryo corresponding to the start time
    String method;  // method used to calculate this onset or the user who entered it it manually
    int start;      // the index time of the start of the expression window
    float startSlope;
    int end;        // the index time of the end of the expression window
    float endSlope;
    float sulstonStart;  // the sulston time of the onset
    float sulstonEnd;  // the sulston time of the onset
    float base;    // the expression baseline value for the embryo
    float mean;   // the mean expression above baseline in the window
    String type;    // the type of expression data used to determine the owindow (ie zblot)
    String leaf;    // the leaf time series used to calculate or manually set the onset
    
    String label;   // a label for debugging , not saved in the database
    float confidence;  // the confidence that this is really an expression window
}
