 /*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression;
import java.io.PrintStream;
import org.rhwlab.db.MySql;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
/**
 *
 * @author gevirl
 */
public class ExpressionOnset {
    public ExpressionOnset(){
        
    }
    public ExpressionOnset(int onset,double base,double slope){
        this.onset = onset;
        this.base = base;
        this.slope = slope;
    }
    static public List<String> seriesForGene(MySql db,String gene) throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        String sql = String.format("select distinct O.Series from  Onsets O,Series S where O.Series=S.ID and S.RedSig=\'%s\'",gene);
        ResultSet rs = db.execute(sql);
        while (rs.next()){
            ret.add(rs.getString("Series"));
        }
        return ret;
    }
    static public List<String> allGenes(MySql db) throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        String sql = "select distinct S.RedSig Gene from  Onsets O,Series S where O.Series=S.ID";
        ResultSet rs = db.execute(sql);
        while (rs.next()){
            ret.add(rs.getString("Gene"));
        }
        return ret;
    }
    // save this onset to the MySql database - adds or replaces the onset
    public void saveToDB(MySql db) throws Exception {
        // is this a new record
        String sql = String.format("select * from Onsets where Series=\'%s\' and Cell=\'%s\'",this.series,this.cell);
        ResultSet rs = db.execute(sql);
        if (!rs.first()){
            // add the new record
            sql = String.format("Insert into Onsets (Series,Cell) values (\'%s\',\'%s\')",this.series,this.cell);
            db.execute(sql);            
        } 
        //update the data
            
        sql = String.format("Update Onsets set Confidence=%f,TimeIndex=%d,SulstonTime=%f,Rate=%f,Date=NOW(),Base=%f,EnteredBy=\'%s\',ExpressionType=\'%s\',leaf=\'%s\'"+ 
                    " where Series=\'%s\' and Cell=\'%s\'",
                    confidence,onset,sulston,slope,base,method,type,leaf,series,cell);
        try {
        db.execute(sql);   
        } catch (Exception exc){
            int asdjf=0;
        }
        
    }
    // remove all onsets for the series
    static public void removeOnsetsFromDB(MySql db,String series) throws Exception {
        String sql = String.format("Delete from Onsets where Series=\'%s\'",series);
        db.execute(sql);
    }
    // read all the onsets for a series
    static public HashMap<String,ExpressionOnset> getOnsetsFromDB(MySql db,String series) throws Exception {
        HashMap<String,ExpressionOnset> ret = new HashMap<String,ExpressionOnset>();
        String sql = String.format("select * from Onsets where Series=\'%s\'",
                series);
        ResultSet rs = db.execute(sql);
        while (rs.next()){
            ExpressionOnset eo = new ExpressionOnset();
            eo.initFromResultSet(series, rs);
            ret.put(eo.cell, eo);
        }
        return ret;
    }
    // use a ResultSet to initialize the values of this ExpressionOnset
    private void initFromResultSet(String series,ResultSet rs) throws Exception {
        this.series = rs.getString("Series");
        this.cell = rs.getString("Cell"); 
        this.method = rs.getString("EnteredBy");
        this.onset = rs.getInt("TimeIndex");
        this.sulston = rs.getFloat("SulstonTime");
        this.slope = rs.getDouble("Rate");
        this.base = rs.getDouble("Base");
        this.type = rs.getString("ExpressionType")   ;
        this.leaf = rs.getString("Leaf");
        this.confidence = rs.getFloat("Confidence");
    }
    public void setOnset(int on){
        onset = on;
    }
    public int getOnset(){
        return onset;
    }
    
    public void setMethod(String meth){
        this.method = meth;
    }
    public String getMethod(){
        return method;
    }
    public void setSlope(double s){
        this.slope = s;
    }
    public double getSlope() {
        return slope;
    }
    public void setBase(double b){
        this.base = b;
    }
    public double getBase(){
       return base;
    }
    public void setSulston(float sul){
        sulston = sul;
    }
    public float getSulston(){
        return sulston;
    }
    public void setCell(String cell){
        this.cell = cell;
    }
    public String getCell(){
        return this.cell;
    }
    public void setLabel(String l){
        this.label = l;
    }
    public String getLabel(){
        return this.label;
    }
    public void setSeries(String ser){
        this.series = ser;
    }
    public void setType(String t){
        this.type = t;
    }
    public void setLeaf(String l){
        this.leaf = l;
    }
    public void dump(PrintStream stream){
        stream.printf("%s,%s,%s,%d,%f,%f,%f,%s,%s\n",
                series,cell,leaf,onset,sulston,base,slope,method,type);
    }
    public void setConfidence(double con){
        this.confidence = con;
    }
    public double getConfidence(){
        return this.confidence;
    }
    public String getType(){
        return this.type;
    }
    String series;
    String cell;    // the cell in the embryo in which this onset is located
    String method;  // method used to calculate this onset or the user who entered it it manually
    int onset;      // the index time of the onset
    float sulston;  // the sulston time of the onset
    double base;    // the expression baseline value fro the embryo
    double slope;   // the rate of expression growth from the onset
    String type;    // the type of expression data used to determine the onset (ie zblot)
    String leaf;    // the leaf time series used to calculate or manually set the onset
    
    String label;   // a label for debugging , not saved in the database
    double confidence;  // the confidence that this is really an onset of expression
}
