/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.expression;
import java.util.ArrayList;
import flanagan.analysis.Regression;
/**
 *
 * @author gevirl
 */

public class CompositeTimeSeries implements TimeSeries{
    public CompositeTimeSeries(String label) {
        list = new ArrayList<TimeSeries>();
        this.label = label;
    }
    // insert a time series at the begining
    public void insert(TimeSeries simple){
        list.add(0, simple);
    }
    
    // insert a composite time series at the begining
    public void insert(CompositeTimeSeries comp){
        for (int i=comp.getSeriesCount()-1 ; i>=0 ; --i){
            this.insert(comp.getSeries(i));
        }
    }
    public RegressionResult doRegression(int onset,boolean limit) {
        
        // do the left regression - use all the points to the left 
        double[] ys = this.getDouble(0, onset);
        double[] xs = new double[onset+1];
        for (int i=0 ; i<=onset ; ++i){
            xs[i] = (double)i;
        }
        Regression reg = new Regression(xs,ys);
        reg.constant();
        double[] estimates = reg.getBestEstimates();
        double eLeft = reg.getSumOfSquares(); 
        
        // do the right regression
        int n = this.size()-onset;  // all the point to the left
        if (limit){
            n = Math.min(window,n);  // limit to the window size 
        }
        int top = onset + n -1;        // index of the last time point
        ys = this.getDouble(onset,top);
        
        xs = new double[n];
        for (int i=0 ; i<n ;++i){
            xs[i] = (double)(i);
        }
        reg = new Regression(xs,ys);
        reg.linear(estimates[0]);
        double eRight = reg.getSumOfSquares(); 
        double[] coefs = reg.getBestEstimates();
        double error =  Math.sqrt(eLeft*eLeft+eRight*eRight);   
        
        RegressionResult res = new RegressionResult();
        res.setError(error);
        res.setBase(estimates[0]);
        res.setSlope(coefs[0]);
        return res;
    }    
    public int getMin(){
        int m = Integer.MAX_VALUE;
        for (TimeSeries s : list){
            if (s.getMin()< m) m = s.getMin();
        }
        return m;
    }
    public int getMax(){
        int m = Integer.MIN_VALUE;
        for (TimeSeries s : list){
            if (s.getMax()> m) m = s.getMax();
        }
        return m;
    }  
    
    // gets the range of values in the time series
    public int getRange(){
        return this.getMax()-this.getMin();
    }
    // the total length of the time series
    public int size() {
        int ret = 0;
        for (TimeSeries s : list){
            ret = ret + s.size();
        }
        return ret;
    }
    // get a single time series value
    public int get(int i) {
        TimeSeries s = findSeries(i);
        if (s == null) throw new IndexOutOfBoundsException();        
        return s.get(remain);
    }
    // get the label of the simple time series with data point at index i
    public String getLabel(int i){
        TimeSeries s = findSeries(i);
        if (s == null) throw new IndexOutOfBoundsException();
        return s.getLabel();
    }
    // get the label of this composite time series
    public String getLabel(){
        return label;
    }
    public String getLastLabel(){
        return list.get(list.size()-1).getLabel();
    }
    // find the simple series that has the ith value
    public TimeSeries findSeries(int i){
         for (TimeSeries s : list) {
            if (i < s.size()){
                remain = i;
                return s;
            }
            i = i - s.size();
        }
         return null;
    }
    public int getSeriesCount() {
        return list.size();
    }
    public TimeSeries getSeries(int i){
        return list.get(i);
    }
    
    // get a range of values from the time series
    public double[] getDouble(int s,int e){
        int n = e-s+1;
        if (n <= 0) return null;
        double[] ret = new double[n];
        for (int i=0 ; i<n ; ++i){
            ret[i] = (double)this.get(s+i);
        }
        return ret;
    }
    public double[] getAllDouble(){
        if (allData == null){
            allData = getDouble(0,this.size()-1);
        }
        return allData;
    }
    
    // get a range of values, may return less than requested if there are not enough values
    public int[] getInteger(int start,int n) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i=0 ; i<n ; ++i){
            try {
                int value = get(start + i);
                list.add(new Integer(value));
            } catch (Exception exc){
                break;
            }
        }
        int[] ret = new int[list.size()];
        for (int i=0 ; i<ret.length;++i){
            ret[i] = list.get(i);
        }
        return ret;
    }
    public double[] getLogAll(double eMin){
        allData = getAllDouble();
        if (logAll == null){
            logAll = new double[allData.length];
            for (int i=0; i <logAll.length ; ++i){
                logAll[i] = Math.log(1.0 + allData[i]-eMin);
            }            
        }
        return logAll;
    }
    double[] logAll = null;
    double[] allData=null;
    int remain;
    ArrayList<TimeSeries> list;
    String label;
    static public int window = 50;  // window size used for regression analysis 
}