/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.rhwlab.expression;
import org.rhwlab.beans.EmbryoCell;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;
import java.util.ArrayList;
/**
 *
 * @author gevirl
 */
public class CellDataTimeSeries extends SimpleTimeSeries {
    // construct the simple time series for the given cell 
    public CellDataTimeSeries(EmbryoCell cell,String type){
        super(cell.getExpression(type),cell.getName());
        this.cell = cell;
        listeners = new ArrayList<ChangeListener>();
    }
    
    public void addOnsetListener(ChangeListener listen){
        listeners.add(listen);
    }
    public void setExprOnset(ExpressionOnset on,boolean change){
        exprOnset = on;
        setChanged(change);
        
        // notify the listeners there has been a change to the expression onset
        if (change){
            for (ChangeListener listener : listeners){
                listener.stateChanged(new ChangeEvent(this));
            }
        }
       
    }
    public ExpressionOnset getExprOnset(){
        return exprOnset;
    }
    private void setChanged(boolean change){
        changed = change;
    }
    public boolean getChanged(){
        return this.changed;
    }
    // clear the onset in this cell time series and any later cell time series 
    // clears onsets in the entire subtree rooted at the cell coresponding to this CellDataTimeSeries
    public void clearOnset() {
  //      System.out.printf("CellDataTimeSeries: clearing %s\n", this.cell.getName());
        if (exprOnset != null){
            exprOnset = null;
            changed = true;
        }
        int n = cell.getChildCount();
        for (int i=0 ; i<n ; ++i){
            EmbryoCell child = (EmbryoCell)cell.getChildAt(i);
            child.getExpTimeSeries().clearOnset();
        }
    }
    public int[] getValuesUptoOnset(){
        int on = exprOnset.getOnset();
        int[] ret = new int[on];
        for (int i=0 ; i<on ; ++i){
            ret[i] = this.get(i);
        }
        return ret;
    }
    public EmbryoCell getCell(){
        return cell;
    }
    EmbryoCell cell;
    ExpressionOnset exprOnset = null;
    boolean changed = false;
    ArrayList<ChangeListener> listeners;
}