/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.density.estimator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.TreeMap;

/**
 *
 * @author gevirl
 */
public class Binning implements Estimator{
    public Binning(){
        
    }

    public void init()throws Exception {
        int total=0;
        int na=0;
        counts = new TreeMap<>();
        f = Math.pow(10.0, precision);
        
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null){
            ++total;
            if (line.equalsIgnoreCase("NA")){
                ++na;
            } else{
                double v = Double.valueOf(line);
                Double key = Math.floor(f*v);
                Integer count = counts.get(key);
                if (count == null){
                    count = new Integer(0);
                }
                counts.put(key, ++count);
            }
            line = reader.readLine();
        }
        reader.close();
    }
    public double getMode(){
        double f = Math.pow(2.0, precision);
        double ret = Double.NaN;
        int max = Integer.MIN_VALUE;
        for (Double key : counts.keySet()){
            Integer count = counts.get(key);
            if (count > max){
                max = count;
                ret = key;
            }
        }
        return ret/f;
    }
    @Override
    public void setFile(Object obj){
        if (obj instanceof String){
            file = (String)obj;
        } else {
            file = ((File)obj).getPath();
        }
    }
    public void setPrecision(Object obj){
        if (obj instanceof Integer){
            precision=(Integer)obj;
        }
    }


    @Override
    public double[] getX() {
        double[] xs = new double[counts.size()];
        int i= 0;
        for (Double x : counts.navigableKeySet()){
            xs[i] = x/f;
            ++i;
        }
        return xs;
    }

    @Override
    public double[] getProb() {
        double[] ps = new double[counts.size()];
        int i= 0;
        for (Integer p : counts.values()){
            ps[i] = (double)p/(double)counts.size();
            ++i;
        }
        return ps;        
    }
    public double getFraction(){
        return (double)na/(double)total;
    }
    int total;
    int na;
    double f;
    int precision=3;
    String file;
    TreeMap<Double,Integer> counts;
}
