/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.demux;

import htsjdk.samtools.fastq.FastqReader;
import htsjdk.samtools.fastq.FastqRecord;
import htsjdk.samtools.fastq.FastqWriter;
import htsjdk.samtools.fastq.FastqWriterFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import org.apache.commons.text.similarity.LevenshteinDistance;

/**
 *
 * @author gevirl
 */
public class SimpleDemux{
    FastqReader indexReader;
    FastqReader read1Reader;
    FastqReader read2Reader;
    TreeMap<String,FastqWriter[]> barcodeMap = new TreeMap<>();
    FastqWriter matchIndex;
//    FastqWriter noMatchIndex;
//    FastqWriter noMatch1;
//    FastqWriter noMatch2;
    
    public SimpleDemux(String dir,String indexFile,String read1File,String read2File,String sampleSheetFile) throws Exception {
        
        indexReader = new FastqReader(new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(dir,indexFile))))));
        read1Reader = new FastqReader(new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(dir,read1File))))));
        read2Reader = new FastqReader(new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(dir,read2File))))));

        FastqWriterFactory factory = new FastqWriterFactory();
        matchIndex = factory.newWriter(new File(dir,"matchIndex.fastq"));
//        noMatchIndex = factory.newWriter(new File(dir,"noMatchIndex.fastq"));
 //       noMatch1 = factory.newWriter(new File(dir,"noMatch1.fastq"));
 //       noMatch2 = factory.newWriter(new File(dir,"noMatch2.fastq"));
        
        BufferedReader reader = new BufferedReader(new FileReader(new File(dir,sampleSheetFile)));
        String line = reader.readLine();
        line = reader.readLine();
        line = reader.readLine();
        while (line != null){
            String[] tokens = line.split(",");
            FastqWriter[] writers = new FastqWriter[2];
            writers[0] = factory.newWriter(new File(dir, tokens[0]+".R1.fastq"));
            writers[1] = factory.newWriter(new File(dir, tokens[0]+".R2.fastq"));
            barcodeMap.put(tokens[2], writers);
            line = reader.readLine();
        }
        reader.close();
    }
    public void demux(){
        LevenshteinDistance leven = LevenshteinDistance.getDefaultInstance();
        while (indexReader.hasNext()){
            FastqRecord indexRec = indexReader.next();
            String indexRead = indexRec.getReadString();
            FastqRecord read1Rec = read1Reader.next();
            FastqRecord read2Rec = read2Reader.next();
            for (String barcode  : barcodeMap.keySet()){
                Integer miss = leven.apply(barcode, indexRead);
                if (miss <= 1){
                    FastqWriter[] writers = barcodeMap.get(barcode);
                    FastqRecord rec1 = new FastqRecord(fixHeader(read1Rec.getReadHeader(),barcode),read1Rec.getReadString(),read1Rec.getBaseQualityHeader(),read1Rec.getBaseQualityString());
                    FastqRecord rec2 = new FastqRecord(fixHeader(read2Rec.getReadHeader(),barcode),read2Rec.getReadString(),read2Rec.getBaseQualityHeader(),read2Rec.getBaseQualityString());
                    writers[0].write(rec1);
                    writers[1].write(rec2);
                    matchIndex.write(indexRec);
                    break;
                }

            }
        }
        
        // close all the files
        indexReader.close();
        read1Reader.close();
        read2Reader.close();
        for (FastqWriter[] writers : barcodeMap.values()){
            writers[0].close();
            writers[1].close();
        }
//        noMatchIndex.close();
//        noMatch1.close();
 //       noMatch2.close();
        matchIndex.close();
    }
    
    private String fixHeader(String header,String barcode){
        String[] heads = header.split(" ");
        String[] tokens = heads[1].split(":");
        return String.format("%s %s:%s:%s:%s",heads[0],tokens[0],tokens[1],tokens[2],barcode);
    }

    static public void main(String[] args) throws Exception {
        SimpleDemux demux = new SimpleDemux("/net/waterston/vol9/160623_NS500488_0192_AH332HBGXY",
                "Undetermined_S0_I1_001.fastq.gz",
                "Undetermined_S0_R1_001.fastq.gz",
                "Undetermined_S0_R2_001.fastq.gz",
                "SampleSheet.csv");
        demux.demux();
    }
}
