/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.db.beans;
import java.util.*;
import java.net.*;
import javax.xml.parsers.*;
import javax.xml.xpath.*;
import org.w3c.dom.*;
import org.rhwlab.db.MySql;
import java.sql.*;

/**
 *
 * @author gevirl
 */
public class WBGene {
    public WBGene() throws Exception {
        if (builder == null){
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        if (xpath == null){
            xpath = XPathFactory.newInstance().newXPath();
        }
    }
    // update the MySql database for geiven WBGeneID from Wormbase
    static public void updateFromWormBase(MySql db,String WBGeneID) throws Exception {
        WBGene wbGene = new WBGene();
        wbGene.fetchFromWormBase(WBGeneID);
        
        // update the WBGene table
        wbGene.addAliasesToWBGeneTable(db);  
        
        // update the Gene table
        Gene gene = new Gene(wbGene);
        gene.updateDB(db);
        
    }

    // update the WBGene table with the alias in this object
    // this does not remove any aliases, it only adds more if there are new values
    public void addAliasesToWBGeneTable(MySql db) throws Exception {
                for (String alias : this.aliases){
                    String sql = String.format("Select * from WBGenes where WBGene=\'%s\' and Alias=\'%s\'",this.ID,alias);
                    ResultSet rs3 = db.execute(sql);
                    if (!rs3.next()){
                        sql = String.format("Insert into WBGenes (WBGene,Alias) values (\'%s\',\'%s\')",this.ID,alias);
                        db.execute(sql);
                    }
                }         
    }
    // load the WBGene table with all aliases found in wormbase, using all the genes in Transcripts table
    static public void loadDB(MySql db) throws Exception {
        String sql = "Select distinct WBGene from Transcript";
        ResultSet rs = db.execute(sql);
        WBGene gene = new WBGene();
        while (rs.next()){
            String wbgeneName = rs.getString("WBGene");
            
            // has this gene already been loaded?
            sql = String.format("Select * from WBGenes where WBGene=\'%s\'",wbgeneName);
            ResultSet rs2 = db.execute(sql) ;
            if (!rs2.next()){
                System.out.println(wbgeneName);
            
                // add all the aliases
                gene.fetchFromWormBase(wbgeneName);
                for (String alias : gene.getAliases()){
                    sql = String.format("Select * from WBGenes where WBGene=\'%s\' and Alias=\'%s\'",wbgeneName,alias);
                    ResultSet rs3 = db.execute(sql);
                    if (!rs3.next()){
                        sql = String.format("Insert into WBGenes (WBGene,Alias) values (\'%s\',\'%s\')", wbgeneName,alias);
                        db.execute(sql);
                    }
                }                
            }                  
        }
    }
    
    public void fetchFromWormBaseByAlias(MySql db,String alias) throws Exception {
        // find the WBGene id
        String sql = String.format("Select * from WBGenes where Alias=\'%s\'",alias);
        ResultSet rs = db.execute(sql);
        if (rs.next()){
            fetchFromWormBase(rs.getString("WBGene"));
        }
        
    }
    // initialize this WBGene object from wormbase given an WBGene id
    public void fetchFromWormBase(String id) throws Exception  {
        this.ID = id;
        this.aliases = new HashSet<String>();
        URL url = new URL(String.format("http://www.wormbase.org/db/misc/xml?name=%s;class=Gene",id));
        Document doc = builder.parse(url.openStream());
        NodeList nodelist = (NodeList)xpath.evaluate("ACEDB/Gene/Identity/Name/*/@value", doc, XPathConstants.NODESET);
        if (nodelist == null) return ;
        
        for (int i=0 ; i<nodelist.getLength();++i){
            Node node = nodelist.item(i);
            String value =node.getNodeValue();
            if (value != null) aliases.add(value);
        }
        CGC = xpath.evaluate("ACEDB/Gene/Identity/Name/CGC_name/@value", doc);
        seqName = xpath.evaluate("ACEDB/Gene/Identity/Name/Sequence_name/@value", doc);
    }
    public String getID(){
        return this.ID;
    }
    public HashSet<String> getAliases(){
        return this.aliases;
    }
    static public void main(String[] args){
        try {
            MySql db = MySql.getMySql();
 //           WBGene.loadDB(db);
            updateFromWormBase(db,args[0]);
            
        } catch (Exception exc){
            exc.printStackTrace();
        }
    }
    public String getCGC(){
        return CGC;
    }
    public String getSequenceName(){
        return seqName;
    }
    String ID;
    String CGC;  // the CGC name
    String seqName;  // the wormbase sequence name
    HashSet<String> aliases;
    static XPath xpath;
    static DocumentBuilder builder ;    
}
