/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.db.beans;
import java.util.*;
import org.rhwlab.db.MySql;
import java.sql.*;
/**
 *
 * @author gevirl
 */
public class Project {
    // load this project object from the database
    // id will be null if the project is not found
    public void loadFromDB(MySql db,String proj) throws Exception {
        String sql = String.format("Select * from Projects where ProjectID=\'%s\'",proj);
        ResultSet rs = db.execute(sql);
        if (rs.next()){
            id = proj;
            query = rs.getString("Query");
            basedOn = rs.getString("BasedOn");
            seriesList = new ArrayList<String>();
            
            // get all the series for this project
            ResultSet rs2 = db.execute(this.query);
            while (rs2.next()){
                seriesList.add(rs2.getString("Series"));
            }
        } else {
            id = null;
        }
    }
    // get all the projects from the database
    static public Project[] allProjects(MySql db) throws Exception {
        ArrayList<Project> projects = new ArrayList<Project>();
        String sql = "Select * from Projects";
        ResultSet rs = db.execute(sql);
        while (rs.next()){
            String projectID = rs.getString("ProjectID");
            Project project = new Project();
            project.loadFromDB(db,projectID);
            projects.add(project);
        }
        return projects.toArray(new Project[0]);
    }
    // get all the project ids from the database
    static public String[] allProjectIDs(MySql db) throws Exception {
        Project[] projects = Project.allProjects(db);
        String[] ids = new String[projects.length];
        for (int i=0 ; i<ids.length ; ++i){
            ids[i] = projects[i].id;
        }
        return ids;
    }
    public String getID(){
        return id;
    }
    public List<String> getSeriesList(){
        return seriesList;
    }
    public String getQuery(){
        return query;
    }
    public boolean isListBased(){
        return basedOn.equals("List");
    }
    String id;
    String query;
    String basedOn;
    List<String> seriesList;
}
