/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.db.beans;
import jxl.*;
import org.rhwlab.db.MySql;
import java.sql.*;
/**
 *
 * @author gevirl
 */
public class Plasmid {
    public void fromSheetRow(Sheet sheet,int row){
        Cell[] heads = sheet.getRow(0);
        Cell[] rowCells = sheet.getRow(row);
        for (int i=0 ; i<heads.length ; ++i){
            String head = heads[i].getContents();
            if (head.equals("Plasmid Name")){
                this.name = rowCells[i].getContents();
            } else if (head.equals("Transcript")){
                this.transcript = rowCells[i].getContents();
            } else if (head.equals("Gene")) {
                this.gene = rowCells[i].getContents();
            } else if (head.equals("Left Primer")){
                this.leftPrimer = rowCells[i].getContents();
            } else if (head.equals("Right Primer")){
                this.rightPrimer = rowCells[i].getContents();
            } else if (head.equals("Vector")){
                this.vector = rowCells[i].getContents();                
            } else if (head.equals("Length")) {
                try {
                    this.promoterLength = Integer.valueOf(rowCells[i].getContents());
                }catch (Exception exc){
                    this.promoterLength = null;
                }
                
            } else if (head.equals("Integrated-Expressing Strains")){
                try {
                    this.strains = Integer.valueOf(rowCells[i].getContents());
                }catch (Exception exc){
                    this.strains = null;
                }
            }

        }
    } 
    public void toMySql(MySql db) throws Exception {
        // is there a strain record in the db?
        String sql = String.format("Select * from Plasmids where Plasmid=\'%s\'", this.name);
        ResultSet  rs = db.execute(sql);
        if (!rs.next()){
            // add a new record for this strain
            sql = String.format("Insert into Plasmids (Plasmid) values (\'%s\')", this.name);  
            db.execute(sql);
        } else {
            System.out.printf("Duplicate plamid: %s\n", this.name);
        }
        // update the values
        if (this.gene != null){
            sql = String.format("Update Plasmids set Gene=\'%s\' where Plasmid=\'%s\'",this.gene,this.name);
            db.execute(sql);            
        }
        if (this.leftPrimer != null){
            sql = String.format("Update Plasmids set LeftPrimer=\'%s\' where Plasmid=\'%s\'",this.leftPrimer,this.name);
            db.execute(sql);               
        }
        if (this.rightPrimer != null){
            sql = String.format("Update Plasmids set RightPrimer=\'%s\' where Plasmid=\'%s\'",this.rightPrimer,this.name);
            db.execute(sql);               
        } 
        if (this.vector != null){
            sql = String.format("Update Plasmids set Vector=\'%s\' where Plasmid=\'%s\'",this.vector,this.name);
            db.execute(sql);               
        } 
        if (this.transcript != null){
            sql = String.format("Update Plasmids set Transcript=\'%s\' where Plasmid=\'%s\'",this.transcript,this.name);
            db.execute(sql);               
        }        
        if (this.promoterLength != null){
            sql = String.format("Update Plasmids set PromoterLength=%d where Plasmid=\'%s\'",this.promoterLength,this.name);
            db.execute(sql);               
        }   
        if (this.strains != null){
            sql = String.format("Update Plasmids set Strains=%d where Plasmid=\'%s\'",this.strains,this.name);
            db.execute(sql);               
        }         

    }   
    static public Plasmid fromMySql(MySql db,String plasmidName) throws Exception {
        String sql = String.format("Select * from Plasmids where Plasmid=\'%s\'", plasmidName);
        ResultSet rs = db.execute(sql);
        if (rs.next()){
            Plasmid plasmid = new Plasmid();
            plasmid.name = plasmidName;
            plasmid.gene = rs.getString("Gene");
            plasmid.transcript = rs.getString("Transcript");
            plasmid.promoterLength = rs.getInt("PromoterLength");
            plasmid.leftPrimer = rs.getString("LeftPrimer");
            plasmid.rightPrimer = rs.getString("RightPrimer");
            plasmid.vector = rs.getString("Vector");
            plasmid.strains = rs.getInt("Strains");
            return plasmid;
        }
        return null;
        
    }
    static public Plasmid fromMySql(String plasmidID) throws Exception {
        String sql = String.format("Select * from Plasmid where PlasmidID=\'%s\'", plasmidID);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            Plasmid plasmid = new Plasmid();
            plasmid.name = rs.getString("PlasmidName");
            plasmid.gene = rs.getString("Gene");
            plasmid.transcript = rs.getString("Transcript");
            plasmid.vector = rs.getString("Vector");
            
            int design = rs.getInt("Design");
            sql = String.format("select * from PrimerDesign where Transcript=\'%s\' and Design=%d",plasmid.transcript,design);
            ResultSet designRS = MySql.getMySql().execute(sql);
            designRS.next();       
            plasmid.promoterLength = designRS.getInt("SequenceLength");
            plasmid.leftPrimer = designRS.getString("LPrimer");
            plasmid.rightPrimer = designRS.getString("RPrimer");
            
            String constructID = rs.getString("PlasmidID");
            sql = String.format("select StrainID from Strain where ConstructID=\'%s\'",constructID);
            ResultSet strainRS = MySql.getMySql().execute(sql);
            plasmid.strains = 0;
            while (strainRS.next()) 
                ++plasmid.strains ;
            return plasmid;
        }
        return null;
        
    }    
    public String getName(){
        return this.name;
    }
    public String getGene(){
        return gene;
    }
    public String getTranscript(){
        return this.transcript;
    }
    public Integer getPromoterLength(){
        return this.promoterLength;
    }
    public String getLeftPrimer(){
        return this.leftPrimer;
    }
    public String getRightPrimer() {
        return this.rightPrimer;
    }
    public Integer getStrains(){
        return this.strains;
    }
    public String getVector(){
        return vector;
    }
    String name;
    String gene;
    String transcript;
    Integer promoterLength;
    String leftPrimer;
    String rightPrimer;
    String vector;
    Integer strains;
}
