/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.db.beans;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.rhwlab.db.MySql;
import org.rhwlab.imaging.TIFF;
import org.w3c.dom.Document;

/**
 *
 * @author gevirl
 */
public class Imaged implements Comparable {
    public Imaged(String id) throws Exception {
        this();
        this.id = id;
        this.fromSQL();
    }
    public Imaged()throws Exception {
        if (builder == null) builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        if (xpath==null) xpath = XPathFactory.newInstance().newXPath();    
    }
    // update the mysql database with this series meta data
    public void updateDB()throws Exception {
        MySql db = MySql.getMySql();
        // is there already a record for this series
        String sql = String.format("Select * from Imaged where ID=\'%s\'",id);
        ResultSet rs = db.execute(sql);
        if (!rs.next()){
            // insert a new record
            sql = String.format("Insert into Imaged (ID) values (\'%s\')",id);
            db.execute(sql);
        }
        // update the record with available data
        if (this.person != null){
            sql = String.format("Update Imaged set Person=\'%s\' where ID=\'%s\'",this.person,id);
            db.execute(sql);
        }
        if (this.strain != null){
            sql = String.format("Update Imaged set Strain=\'%s\' where ID=\'%s\'",this.strain,id);
            db.execute(sql);
        } 
        if (this.treatments != null){
            sql = String.format("Update Imaged set Treatments=\'%s\' where ID=\'%s\'",this.treatments,id);
            db.execute(sql);
        } 
        if (this.redSig != null){
            sql = String.format("Update Imaged set RedSig=\'%s\' where ID=\'%s\'",this.redSig,id);
            db.execute(sql);
        }
        if (this.imageDir != null){
            sql = String.format("Update Imaged set ImageDir=\'%s\' where ID=\'%s\'",this.imageDir,id);
            db.execute(sql);
        }
        if (this.imageFile != null){
            sql = String.format("Update Imaged set ImageFile=\'%s\' where ID=\'%s\'",this.imageFile,id);
            db.execute(sql);
        }        
        if (this.annotsDir != null){
            sql = String.format("Update Imaged set AnnotsDir=\'%s\' where ID=\'%s\'",this.annotsDir,id);
            db.execute(sql);
        }
        if (this.aceTree != null){
            sql = String.format("Update Imaged set AceTree=\'%s\' where ID=\'%s\'",this.aceTree,id);
            db.execute(sql);
        }        
        if (this.nucleiFile != null){
            sql = String.format("Update Imaged set NucleiFile=\'%s\' where ID=\'%s\'",this.nucleiFile,id);
            db.execute(sql);
        }        
        if (this.editedBy != null){
            sql = String.format("Update Imaged set EditedBy=\'%s\' where ID=\'%s\'",this.editedBy,id);
            db.execute(sql);
        }
        if (this.checkedBy != null){
            sql = String.format("Update Imaged set CheckedBy=\'%s\' where ID=\'%s\'",this.checkedBy,id);
            db.execute(sql);
        }
        if (this.comments != null){
            // escape any single quotes in the comment
            String c = comments.replace("'","\"");
            sql = String.format("Update Imaged set Comments=\'%s\' where ID=\'%s\'",c,id);
            db.execute(sql);
        }
        if (this.status != null){
            sql = String.format("Update Imaged set Status=\'%s\' where ID=\'%s\'",this.status,id);
            db.execute(sql);
        }
        if (this.gene != null){
            sql = String.format("Update Imaged set Gene=\'%s\' where ID=\'%s\'",this.gene,id);
            db.execute(sql);
        }   
        if (this.wbGene != null){
            sql = String.format("Update Imaged set WBGene=\'%s\' where ID=\'%s\'",this.wbGene,id);
            db.execute(sql);
        } 
        if (this.construct != null){
            sql = String.format("Update Imaged set ConstructID=\'%s\' where ID=\'%s\'",this.construct,id);
            db.execute(sql);
        }   
        if (this.constructType != null){
            sql = String.format("Update Imaged set ConstructType=\'%s\' where ID=\'%s\'",this.constructType,id);
            db.execute(sql);
        }         
        if (this.timePoints != null){
            sql = String.format("Update Imaged set TimePoints=%d where ID=\'%s\'",this.timePoints,id);
            db.execute(sql);
        }
        if (this.editedTimePoints != null){
            sql = String.format("Update Imaged set EditedTimePoints=%d where ID=\'%s\'",this.editedTimePoints,id);
            db.execute(sql);
        }
        if (this.editedCells != null){
            sql = String.format("Update Imaged set EditedCells=%d where ID=\'%s\'",this.editedCells,id);
            db.execute(sql);
        }
        if (this.seriesDate != null){
            sql = String.format("Update Imaged set SeriesDate=\'%s\' where ID=\'%s\'",getDateAsString(),id);
            db.execute(sql);
        }
        if (this.endPlane != null){
            sql = String.format("Update Imaged set EndPlane=%d where ID=\'%s\'",this.endPlane,id);
            db.execute(sql);
        }  
        if (this.zRes != null){
            sql = String.format("Update Imaged set ZRes=%f where ID=\'%s\'",this.zRes,id);
            db.execute(sql);
        }   
        if (this.xyRes != null){
            sql = String.format("Update Imaged set XYRes=%f where ID=\'%s\'",this.xyRes,id);
            db.execute(sql);
        }  
        
        sql = String.format("Update Imaged set Entered=now()  where ID=\'%s\'",id);
        db.execute(sql);

    }    
    public void fromXML(File xml) throws Exception  {
        Document doc = builder.parse(xml);
        
        // use xpath to extract the values
        id = xpath.evaluate("/experiment/series/@name",doc);
        person = xpath.evaluate("/experiment/person/@name", doc);
        strain = xpath.evaluate("/experiment/strain/@name", doc);
        treatments = xpath.evaluate("/experiment/treatments/@desc", doc);
        redSig = xpath.evaluate("/experiment/redsig/@value", doc);
        timePoints = null;
        try {
            timePoints = new Integer(xpath.evaluate("/experiment/timepts/@num", doc));
        } catch (Exception exc){
//            exc.printStackTrace();
        }
        seriesDate = format.parse(xpath.evaluate("/experiment/date/@date", doc));
        imageDir = xpath.evaluate("/experiment/imageloc/@loc", doc).trim();
        annotsDir = xpath.evaluate("/experiment/annots/@loc", doc).trim();
        editedBy = xpath.evaluate("/experiment/editedby/@name", doc);
        editedTimePoints = null;
        try {
            editedTimePoints = new Integer(xpath.evaluate("/experiment/editedtimepts/@num", doc));
        }catch (Exception exc){
//            exc.printStackTrace();
        }
        editedCells = null;    
        try {
            editedCells = new Integer(xpath.evaluate("/experiment/editedcells/@num", doc));
        } catch (Exception exc){
//            exc.printStackTrace();
        }
        checkedBy = xpath.evaluate("/experiment/checkedby/@name", doc);
        status = xpath.evaluate("/experiment/status/@case", doc);
        comments = xpath.evaluate("/experiment/comments/@text", doc);
        aceTree = xpath.evaluate("/experiment/acetree/@config", doc);
        
        // get the other xml file and parse it
        String annotsXml = annotsDir.trim()+"/dats/"+aceTree;
        File xmlFile = new File(annotsXml);
        if (xmlFile.exists()){
        doc = builder.parse(xmlFile);
            nucleiFile = xpath.evaluate("/embryo/nuclei/@file",doc).trim();
            imageFile = xpath.evaluate("/embryo/image/@file",doc).trim();
        }
        String params = annotsDir.trim()+"/dats/"+id+"-parameters";
        File paramsFile = new File(params);
        if (paramsFile.exists()){
            StarryNightParameters snParams = new StarryNightParameters(paramsFile);
            this.endPlane = snParams.getEndPlane();
            this.zRes = snParams.getZ_res();
            this.xyRes = snParams.getXY_res();
            this.timeInterval = snParams.getTimeInterval();
        }else {
            File matlabFile = new File(annotsDir.trim()+"/dats/mparm.txt");
            MatlabParameters mParams = new MatlabParameters(matlabFile);
            this.endPlane = mParams.getEndPlane();
            this.zRes = mParams.getZ_res();
            this.xyRes = mParams.getXY_res();  
            this.timeInterval = mParams.getTimeInterval();
        }
        
 /*       
        // get the parameters
        planes = null;
        String params = annotsDir.trim()+"/dats/"+id+"-parameters";
        File paramsFile = new File(params);
        if (paramsFile.exists()){
            BufferedReader reader = new BufferedReader(new FileReader(paramsFile));
            String line = reader.readLine();
            while (line != null){
                line = line.trim();
                if (!line.equals("")&&line.charAt(0) != '#'){
                    String[] tokens = line.split(" ");
                    if (tokens[0].equals("plane_end")){
                        planes = new Integer(tokens[1]);
                        System.out.printf("\tFrom parameters    Planes: %d\n",this.planes);
                    }
                }
                line = reader.readLine();
            }
            reader.close();
        } else {
            getPlanes();
            System.out.printf("\tNo parameters file    Planes: %d\n",this.planes);
            
        }
  */      
       
    } 
    public Integer getPlanes(){
/*        
        if (planes == null){
            File dir = new File(getLineageDir());
            File[] files = dir.listFiles(new FilenameFilter(){
                public boolean accept(File file,String name){
                    return name.contains("t001");
                }
            });
            if (files==null) return null;
            planes = new Integer(files.length);
        }
        */
        if (this.endPlane!= null && this.endPlane!=0){
            return this.endPlane;
        } else {
            return new Integer(31);
        }
        
    } 
    public String getLineageDir(){
        int uishdfus=0;
        return getImageDir()+"/tif";
    }  
    // add information from Strain table
    public void fromStrainSQL() throws Exception {
        String sql= String.format("Select * from Strain where StrainID = \'%s\'", this.strain);
        ResultSet strainRS = MySql.getMySql().execute(sql);
        if (strainRS.next()){
            this.gene = strainRS.getString("Gene");
            this.wbGene = strainRS.getString("WBGene");
            this.construct = strainRS.getString("ConstructID");
            this.constructType = strainRS.getString("ConstructType");
        }        
    }
    /*
    public void addToDB()throws Exception{
        PreparedStatement state = MySql.getMySql().getStatement(
                "Insert into Imaged values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        state.setString(1,this.id);
        state.setString(2,this.person);
        state.setString(3,this.strain);
        state.setString(4,this.treatments);
        state.setString(5,this.redSig);
        state.setInt(6,this.timePoints);
        state.setString(7,getDateAsString());
        state.setString(8,this.imageDir);
        state.setString(9,this.aceTree);
        state.setString(10,this.annotsDir);
        state.setString(11,this.imageFile);
        state.setString(12,this.nucleiFile);
        state.setString(13,this.editedBy);
        state.setInt(14,this.editedTimePoints);
        state.setInt(15,this.editedCells);
        state.setString(16,this.checkedBy);
        state.setString(17,this.status);
        state.setString(18,this.comments);
        
    }
    * */
    // get the meta data from the mysql databse
    public boolean fromSQL() throws Exception{
        String sql = String.format("Select * from Imaged where ID=\'%s\'",id);
        ResultSet rs = MySql.getMySql().execute(sql);
        if (rs.next()){
            this.person = rs.getString("Person");
            this.strain = rs.getString("Strain");
            this.treatments = rs.getString("Treatments");
            this.redSig = rs.getString("RedSig").trim(); 
            this.annotsDir = rs.getString("AnnotsDir").trim();
            this.imageDir = rs.getString("ImageDir").trim();
            this.editedBy = rs.getString("EditedBy");
            this.checkedBy = rs.getString("CheckedBy");
            this.status = rs.getString("Status");
            this.comments = rs.getString("Comments"); 
            this.timePoints = (Integer)rs.getObject("TimePoints");
            this.editedTimePoints = (Integer)rs.getObject("EditedTimePoints");
            this.editedCells = (Integer)rs.getObject("EditedCells");
            this.seriesDate = rs.getDate("SeriesDate"); 
            this.nucleiFile = rs.getString("NucleiFile");
            this.imageFile = rs.getString("ImageFile");
            this.aceTree = rs.getString("AceTree");
            this.publish = rs.getBoolean("Publish");
            int e = rs.getInt("EndPlane");
            if (e != 0){
                this.endPlane = e;
            } else {
                this.endPlane = 31;
            }
            this.zRes =(Double)rs.getDouble("ZRes");
            this.xyRes = (Double)rs.getDouble("XYRes");
            this.gene = rs.getString("Gene");
            this.construct = rs.getString("ConstructID");
            this.constructType = rs.getString("ConstructType");  
            this.wbGene = rs.getString("WBGene");
            return true;
        } 
        return false;
    }    
    public String getDateAsString(){
        if (seriesDate != null){
            return sqlFormat.format(seriesDate);
        }
        return null;
    } 
  
    public InputStream getImageJPG(){
        // build the typical image JPG from a tiff
        this.getPlanes();
        if (this.endPlane==null) return null;
        try {
            TIFF tiff = new TIFF(this.imageDir);
            if (tiff.isOK()) {
                if (this.editedTimePoints!=null){
                    tiff.setTimeAndPlane(this.editedTimePoints/2, this.endPlane/2);
                } else {
                    tiff.setTimeAndPlane(this.timePoints/2, this.endPlane/2);
                }
                BufferedImage image = tiff.getImage(true, true);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write(image, "jpg", os);
                imageJPG = new ByteArrayInputStream(os.toByteArray());  
            } 
        }
        catch (Exception exc){
            exc.printStackTrace();
            imageJPG = null;
        } 
        return imageJPG;
    }
    static public ArrayList<String> allPublished()throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        String sql = "Select ID from Imaged where Publish = 1";
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            ret.add(rs.getString(1));
        }
        return ret;
    }
    static public ArrayList<String> publishedByGeneConstruct(String gene,String type)throws Exception {
        ArrayList<String> ret = new ArrayList<>();
        String sql = String.format(
                "Select ID from Imaged where Publish = 1 and Gene=\'%s\' and ConstructType=\'%s\'",
                gene,type);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()){
            ret.add(rs.getString("ID"));
        }
        return ret;        
    }
    // return the edit zip filename
    public String getEditZip(){
        if (this.nucleiFile!=null){
            return this.nucleiFile;
        }
        String[] tokens = annotsDir.split("/");
        return annotsDir+"/dats/"+tokens[tokens.length-1]+"-edit.zip";        
    } 
    public String getEmbryoDBXML(){
        return "/nfs/waterston/embryoDB/" + id + ".xml";
    }
    public String getAcetreeXML(){
        return annotsDir.trim() + "/dats/" + aceTree;
    }
    public String getID(){
        return id;
    }
    public String getImageDir(){
        return this.imageDir;
    } 
    public String getAnnotsDir(){
        return this.annotsDir;
    }
    public String getGene(){
        return gene;
    }
    public String getStrain(){
        return strain;
    }
    public String getPerson(){
        return this.person;
    }
    public String getDate(){
        return sqlFormat.format(seriesDate);
    }
    public String getTreatments(){
        return this.treatments;
    }
    public String getConstruct(){
        return this.construct;
    }
    public String getWBGene(){
        return this.wbGene;
    }
    public Integer getTimePoints(){
        return this.timePoints;
    }
    public Integer getEditedTimePoints(){
        return this.editedTimePoints;
    }
    public Integer getEditedCells(){
        return this.editedCells;
    }
    public String getComments(){
        return this.comments;
    }
    public String getEditedBy(){
        return this.editedBy;
    }
    public Double getZRes(){
        if (this.zRes!=null && this.zRes!=0){
            return this.zRes;
        }else {
            return new Double(1.0);
        }
    }
    public Double getXYRes(){
        if (this.xyRes != null && this.xyRes!=0){
            return this.xyRes;
        } else {
            return new Double(0.09);
        }
    }
    public double getZPixelsPerPlane(){
        if (this.getZRes() != null){
            return this.getZRes()/this.getXYRes();
        } else {
            return 1.0/0.09;
        }       
    }
    public String getConstructType(){
        return this.constructType;
    }public Double getTimeInterval(){
        return this.timeInterval;
    }
    protected String wbGene;
    protected String construct;
    protected String constructType;
    protected String gene;
    protected String id;
    protected String person;
    protected String strain;
    protected String treatments;
    protected String redSig;
    protected Integer timePoints;
    protected Date seriesDate;
    protected String imageDir;
    protected String annotsDir;
    protected String editedBy;
    protected Integer editedTimePoints;
    protected Integer editedCells;
    protected String checkedBy;
    protected String status;
    protected String comments;
    protected String nucleiFile;
    protected String imageFile; 
    protected String aceTree;
    protected boolean publish;
//    protected Integer planes=null;
    protected InputStream imageJPG;
    protected double zPixRes = 1.0/0.09; 
    protected Double xyRes;
    protected Double zRes;
    protected Integer endPlane;
    protected Double timeInterval;
    
    protected static DocumentBuilder builder = null;
    protected static XPath xpath = null;    
    static SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
    static SimpleDateFormat sqlFormat = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public int compareTo(Object o) {
        Imaged other = (Imaged)o;
        return this.id.compareTo(other.id);
    }
}
