/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.db.beans;
import org.rhwlab.db.MySql;
import java.sql.*;
import org.rhwlab.modencode.TSS;
import java.util.*;
import org.rhwlab.mysql.WBGeneAnnotation;
/**
 *
 * @author gevirl
 */
public class Gene {
    public Gene(){
    }
    public Gene(String gene)throws Exception {
        this();
        this.withExons = false;
        this.fromWBGene(MySql.getMySql(),gene);
        if (this.WBGene != null) return;
        
        this.fromMySqlBySequence(MySql.getMySql(), gene);
        if (this.WBGene != null) return;
        
        this.fromMySqlByCGC(MySql.getMySql(), gene);
    }
    public Gene(WBGene wbgene){
        this(wbgene.ID,wbgene.CGC,wbgene.seqName);
        this.withExons = false;
    }
    public Gene(String WBGene,String CGC,String sequence){
        this.CGC = CGC;
        this.Sequence = sequence;
        this.WBGene = WBGene;
        this.withExons = false;
    }
    public WBGeneAnnotation getUpGene(String biotype)throws Exception {
        String sql = String.format("Select * from WBGeneAnnotation where Chromosome=\'%s\' and Start>%d and BioType=\'%s\' order by Start ASC limit 1",
                this.region.chromosome,this.region.end,biotype);
        ResultSet rs = MySql.getMySql().execute(sql);
        WBGeneAnnotation  rightGene = new WBGeneAnnotation();
        rightGene.fromResultSet(rs);
        if (rightGene.getName() == null) return null;
        return rightGene;
    }
    public WBGeneAnnotation getDownGene(String biotype)throws Exception {
        // find the next gene to the left of this gene
        String sql = String.format("Select * from WBGeneAnnotation where Chromosome=\'%s\' and End<%d and BioType=\'%s\' order by End DESC limit 1",
                this.region.chromosome,this.region.start,biotype);
        ResultSet rs = MySql.getMySql().execute(sql);
        WBGeneAnnotation leftGene = new WBGeneAnnotation();
        leftGene.fromResultSet(rs);
        if (leftGene.getName()==null) return null;
        return leftGene;
    }
    // determine the integergenic region (up and down stream) of this gene
    // not finished yet - database is not complete
    public IntergenicRegion intergenicRegion(MySql db,String biotype) throws Exception {
        if (this.region==null){
            return null;
        }

        WBGeneAnnotation leftGene = getDownGene(biotype);;
        WBGeneAnnotation rightGene = getUpGene(biotype);;
        
        if (leftGene==null || rightGene==null) {
        } else {
            return new IntergenicRegion(leftGene,rightGene);
        }
        if (leftGene!=null)
            return new IntergenicRegion(leftGene,Integer.MAX_VALUE);  // I should use the size of the chromosome here - needs to be fixed
        return new IntergenicRegion(1,rightGene);
    }
    // update the MySql database Gene Table with the data in this Gene object
    public void updateDB(MySql db) throws Exception{
            String sql = String.format("Select * from Gene where WBGene = \'%s\'",this.WBGene);
            ResultSet rs2 = db.execute(sql);
            if (!rs2.next()){
                // add the Gene
                sql = String.format("Insert into Gene (WBGene) values (\'%s\')",this.WBGene);
                db.execute(sql);
            }
            // update the gene
            sql = String.format("Update Gene set CGC=\'%s\',Sequence=\'%s\' where WBGene=\'%s\'", this.CGC,this.Sequence,this.WBGene);
            db.execute(sql); 
            if (this.region != null){
                sql = String.format("Update Gene set Chromosome=\'%s\',Strand=%d,Start=%d,End=%d where WBGene=\'%s\'" ,
                        this.region.chromosome,this.region.strand,this.region.start,this.region.end,this.WBGene);
                db.execute(sql);                 
            }
            
    }
    // this updates the Gene table using data from Wormbase 
    // it updates the Gene record for each unique WBGene ID in the WBGene table
    static public void updateFromWormBase(MySql db)throws Exception {
        // set all the WBGenes in the database 
        String sql = "Select distinct WBGene from WBGenes";
        ResultSet rs = db.execute(sql);
        while (rs.next()){
            WBGene wbGene = new WBGene();
            wbGene.fetchFromWormBase(rs.getString("WBGene"));
            sql = String.format("Select * from Gene where WBGene = \'%s\'",wbGene.getID());
            ResultSet rs2 = db.execute(sql);
            if (!rs2.next()){
                // add the WBGene
                sql = String.format("Insert into Gene (WBGene) values (\'%s\')",wbGene.getID());
                db.execute(sql);
            }
            // update the wbgene
            sql = String.format("Update Gene set CGC=\'%s\',Sequence=\'%s\' where WBGene=\'%s\'", wbGene.getCGC(),wbGene.getSequenceName(),wbGene.getID());
            db.execute(sql);
            System.out.println(wbGene.getID());
        }
        
    }
    // update all the genes with chromosome regions from modencode
    static public void updateRegions(MySql db) throws Exception {
        String sql = "Select * from Gene";
        ResultSet rs = db.execute(sql);
        while (rs.next()){
            Gene gene = new Gene(rs.getString("WBGene"),rs.getString("CGC"),rs.getString("Sequence"));  
            System.out.println(gene.WBGene);
            TSS tss = new TSS(gene);
            gene.region = tss.getRegion();
            if (gene.region != null){
            sql = String.format("Update Gene set Chromosome=\'%s\',Strand=%d,Start=%d,End=%d where WBGene=\'%s\'" ,
                        gene.region.chromosome,gene.region.strand,gene.region.start,gene.region.end,gene.WBGene);
            db.execute(sql);   
            }
        }
        
    }
    static public ArrayList<Gene> allGenes(MySql db) throws Exception {
        ArrayList<Gene> ret = new ArrayList<Gene>();
        String sql = "Select * from Gene";
        ResultSet rs = db.execute(sql);
        while (rs.next()){
            Gene gene = new Gene();
            gene.fromResultSet(db,rs);
            ret.add(gene);
        }         
        return ret;
    }
    public final void fromMySqlBySequence(MySql db,String seq)throws Exception {
        String sql = String.format("Select * from Gene where Sequence=\'%s\' ", seq);
        ResultSet rs = db.execute(sql);
        if (rs.next()){
            this.fromResultSet(db,rs);
        }        
    }
    public final void fromMySqlByCGC(MySql db,String cgc)throws Exception {
        String sql = String.format("Select * from Gene where CGC=\'%s\' ", cgc);
        ResultSet rs = db.execute(sql);
        if (rs.next()){
            this.fromResultSet(db,rs);
        }        
    }    
    public final void fromWBGene(MySql db,String wbg)throws Exception {
        String sql = String.format("Select * from Gene where WBGene=\'%s\' ", wbg);
        ResultSet rs = db.execute(sql);
        if (rs.next()){
            this.fromResultSet(db,rs);
        }        
    }    
    public void fromMySqlByAlias(MySql db,String alias) throws Exception {
        String sql = String.format("Select * from Gene G,WBGenes W where G.WBGene=W.WBGene and W.Alias=\'%s\' ", alias);
     //   String sql = String.format("Select G.WBGene WBGene,G.Sequence Sequence,G.CGC CGC from Gene G,WBGenes W where G.WBGene=W.WBGene and W.Alias=\'%s\' ", alias);

        ResultSet rs = db.execute(sql);
        if (rs.next()){
            this.fromResultSet(db,rs);
        }
    }
    public void fromTranscript(MySql db,String transcript) throws Exception {
        String sql = String.format("select * from Transcript T ,Gene G where G.WBGene=T.WBGene and T.TranscriptName=\'%s\'",transcript);
        ResultSet rs = db.execute(sql);
        if (rs.next()){
            this.fromResultSet(db,rs);
        }        
    }
    public void fromResultSetNoExons(ResultSet rs)throws Exception {
        this.WBGene = rs.getString("WBGene");
        this.CGC = rs.getString("CGC");
        this.Sequence = rs.getString("Sequence");
        String chromosome = rs.getString("Chromosome");
        try {
        this.operon = rs.getString("OperonID");
        } catch (Exception exc){}
        this.region = null;
        if (chromosome != null){
            this.region = new GeneRegion(chromosome,rs.getInt("Start"),rs.getInt("End"),rs.getInt("Strand"),false);
        }         
    }
    private void fromResultSet(MySql db,ResultSet rs) throws Exception {
        fromResultSetNoExons(rs);
 
        // load up the exons too
        if (withExons) exons = Exon.getExons(db, this);
    }
    public String getWBGene(){
        return this.WBGene;
    }
    public String getCGC(){
        return this.CGC;
    }
    public String getSequenceName(){
        return this.Sequence;
    }
    public GeneRegion getRegion(){
        return this.region;
    }
    public void setRegion(GeneRegion region){
        this.region = region;
    }
    // return the common name of the gene
    public String getName(){
        if (this.CGC == null || this.CGC.equals("")){
            return this.Sequence;
        }
        return this.CGC;
    }
    public String getOperon(){
        return this.operon;
    }
    public List<Exon> getExons(){
        return exons;
    }
    public String getStrandLabel(){
        if (region.getStrand()==1)
            return "-->";
        return "<--";
    }
    public String toString(){
        return getName();
    }
    public void setWithExons(boolean w){
        this.withExons = w;
    }
 
    // get the genes on a given chromosome sorted by position
    static public ArrayList<Gene> getGenesOnChromosome(String cr)throws Exception {
        
        String sql = String.format("select OperonID,CGC,G.WBGene,Sequence,Chromosome,Strand,min(Start) Start,max(End) End,Gene from Gene G left join OperonGenes O on G.WBGene=O.WBGene where Chromosome = \'%s\' and Strand is not null group by Sequence order by Start",cr);
        ArrayList<Gene> ret = new ArrayList<>();
        ResultSet rs = MySql.getMySql().execute(sql);
        
        while(rs.next()){

            Gene gene = new Gene();
            gene.fromResultSetNoExons(rs);
            ret.add(gene);
        }
        return ret;
    }
   
  /*  
    // get the genes on a given chromosome sorted by position
    static public Set<String> getGenesOnChromosome(String cr)throws Exception {
        String sql = String.format("Select Sequence from Gene where Chromosome = \'%s\' order by Start",cr);
        LinkedHashSet<String> ret = new LinkedHashSet<>();
        ResultSet rs = MySql.getMySql().execute(sql);
        
        while(rs.next()){
            String g = rs.getString("Sequence");
            ret.add(g);
        }
        return ret;
    }  
    */
    // get the genes on a given chromosome sorted by position
    static public List<String> oldgetGenesOnChromosome(String cr)throws Exception {
        String sql = String.format("Select distinct Sequence from Gene where Chromosome = \'%s\' and Strand is not null order by Start",cr);
        ArrayList<String> ret = new ArrayList<>();
        ResultSet rs = MySql.getMySql().execute(sql);
        
        while(rs.next()){
            String g = rs.getString("Sequence");
            ret.add(g);
        }
        return ret;
    }    
    static public void main(String[] args){
        try {
            MySql db = MySql.getMySql();
//            Gene.updateFromWormBase(db);
            Gene.updateRegions(db);
            
        }catch (Exception exc){
            exc.printStackTrace();
        }
    }
    boolean withExons = true;
    String WBGene;
    String CGC;
    String Sequence;
    GeneRegion region;
    List<Exon> exons;
    String operon;
    
}
