/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.db.beans;
import java.util.*;

/**
 *
 * @author gevirl
 */
public class CombinedRegion extends ChromosomeRegion{
    public CombinedRegion(HasRegion region){
        this(region.getRegion().chromosome,region.getRegion().start,region.getRegion().end);
        regions.add(region);
    }
    private  CombinedRegion(String chrom,int s,int e){
        super(chrom,s,e);
        count = 1;
    } 
    // combines this region with another if they overalap
    // return true if they were combined
    public boolean combine(HasRegion hasAnother){
        ChromosomeRegion another = hasAnother.getRegion();
        if (this.overlaps(another)){
            this.start = Math.min(this.start, another.start);
            this.end = Math.max(this.end, another.end);
            ++count;
            regions.add(hasAnother);
            return true;
        }
        return false;
    }
    public int getCount(){
        return count;
    }
    public List<HasRegion> getRegions(){
        return regions;
    }
    public String getLabel(){
        StringBuilder build = new StringBuilder();
        boolean first = true;
        for (HasRegion region : regions){
            if (!first){
                build.append('/');
            }
            first = false;
            build.append(region.getLabel());           
        }
        return build.toString();
    }
    public List<String> getLabelList(){
        ArrayList<String> ret = new ArrayList<String>();
        for (HasRegion region : regions){
            ret.add(region.getLabel());
        }
        return ret;
    }
    ArrayList<HasRegion> regions = new ArrayList<HasRegion>();
    int count;
}