/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.db.beans;
import java.util.*;
import java.io.*;
/**
 *
 * @author gevirl
 */
public class ChipSeqBindingSite implements HasRegion {
    public ChipSeqBindingSite(String gene,String chromo,int s, int e,double p){
        this.gene = gene;
        this.region = new ChromosomeRegion(chromo,s,e);
        this.p = p;
    }
   
    public static List fromCSV(File csv) throws Exception {
        ArrayList<ChipSeqBindingSite> ret = new ArrayList<ChipSeqBindingSite>();
        BufferedReader reader = new BufferedReader(new FileReader(csv));
        String line = reader.readLine();
        String [] headings = line.split(",");
         // identify the columns
        int geneCol=0;
        int chromoCol = 0;
        int startCol = 0;
        int endCol = 0;
        int pCol = 0;
        for (int i=0 ; i<headings.length ; ++i){
            if (headings[i].equals("Gene")) {
                geneCol = i;
            } else if (headings[i].equals("Chromosome")) {
                chromoCol = i;
            } else if (headings[i].equals("Start")){
                startCol = i;                
            } else if (headings[i].equals("End")){
                endCol = i;
            } else if (headings[i].equals("Score")){
                pCol = i;
            }
        }
        line = reader.readLine();
        while (line != null){
            String[] tokens = line.split(",");
            ChipSeqBindingSite bs = new ChipSeqBindingSite(
                    tokens[geneCol].replace("\"","")
                    ,tokens[chromoCol].replace("\"", "")
                    ,Integer.valueOf(tokens[startCol])
                    ,Integer.valueOf(tokens[endCol])
                    ,Double.valueOf(tokens[pCol]));
            ret.add(bs);
            line = reader.readLine();
        }
        return ret;        
    }
    public static List fromModEncodeCSV(File csv) throws Exception {
        ArrayList<ChipSeqBindingSite> ret = new ArrayList<ChipSeqBindingSite>();
        BufferedReader reader = new BufferedReader(new FileReader(csv));
        String line = reader.readLine();
        String [] headings = line.split(",");
        // remove double quotes
        for (int i=0 ; i<headings.length ; ++i){
            headings[i] = headings[i].replace("\"", "");
        }
        
        // identify the columns
        int geneCol=0;
        int chromoCol = 0;
        int startCol = 0;
        int endCol = 0;
        int pCol = 0;
        for (int i=0 ; i<headings.length ; ++i){
            if (headings[i].equals("TF Binding Site > DB identifier")) {
                geneCol = i;
            } else if (headings[i].equals("TF Binding Site > Chromosome > DB identifier")) {
                chromoCol = i;
            } else if (headings[i].equals("TF Binding Site > Chromosome Location > Start")){
                startCol = i;                
            } else if (headings[i].equals("TF Binding Site > Chromosome Location > End")){
                endCol = i;
            } else if (headings[i].equals("TF Binding Site > Score")){
                pCol = i;
            }
        }
        
        line = reader.readLine();
        while (line != null){
            String[] tokens = line.split(",");
            ChipSeqBindingSite bs = new ChipSeqBindingSite(
                    tokens[geneCol].replace("\"","")
                    ,tokens[chromoCol].replace("\"", "")
                    ,Integer.valueOf(tokens[startCol])
                    ,Integer.valueOf(tokens[endCol])
                    ,Double.valueOf(tokens[pCol]));
            ret.add(bs);
            line = reader.readLine();
        }
        return ret;
    }
    public ChromosomeRegion getRegion(){
        return region;
    }
    public String getGene(){
        return gene;
    }
    public void dump(PrintStream stream){
        String[] tokens = gene.split("_");
        stream.printf("%s,",tokens[2]);
        region.dump(stream);
        stream.printf(",%f", p);
    }
    public String getLabel(){
        return gene;
    }
    String gene;
    ChromosomeRegion region;
    double p;
}
