/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.chipseq.notused;

import java.util.List;
import org.rhwlab.db.beans.Gene;
import org.rhwlab.wormbase.GeneModel;
import org.rhwlab.wormbase.GeneModelPosition;
import org.rhwlab.wormbase.GenomePosition;

/**
 *
 * @author gevirl
 */
public class BindingSite {
    public BindingSite(){
        
    }
    public void fromBedFormatEntry(String line){
        String[] tokens = line.split("\t");
        
        String chr = tokens[0];
        if (tokens[0].startsWith("CHROMOSOME_"))
            chr = tokens[0].substring(11);  // skip the characters CHROMOSOME_
        else if (tokens[0].toLowerCase().startsWith("chr"))
            chr = tokens[0].substring(3);
        
        if (chr.contains("Mt")){
            this.chrom = "Mt";
        } else if(chr.equals("1")){
            this.chrom = "I";
        } else if (chr.equals("2")){
            this.chrom = "II";
        }else if (chr.equals("3")){
            this.chrom="III";
        }else if (chr.equals("4")){
            this.chrom = "IV";
        }else if (chr.equals("5")){
            this.chrom = "V";
        }else {
            this.chrom = chr;
        }
        this.start = Integer.valueOf(tokens[1]);
        this.end = Integer.valueOf(tokens[2]);
        
        // use the midpoint of the peak if no offset provided
        int mid = (start+end)/2;
        try {
            int v = Integer.valueOf(tokens[4]);
            if (v > 0) mid = start + v;
        } catch(Exception exc){}
        pos = new GenomePosition(chrom,mid);
        
        try {
            score = Double.valueOf(tokens[3]);
        } catch (Exception exc){
            score = 0;
        }
        
    }
    // locate the potential wormabase genes that could be associated with this bindsite
    public void potentialGenes() throws Exception {
        intra = GeneModel.withinGenes(pos);
        inter[0] = GeneModel.downFrom(pos,1);
        inter[1] = GeneModel.upFrom(pos, 1);
        inter[2] = GeneModel.downFrom(pos,-1);
        inter[3] = GeneModel.upFrom(pos,-1);
    }
    public List<GeneModelPosition> getIntra(){
        return intra;
    }
    public GeneModelPosition[] getInter(){
        return inter;
    }
    public double getScore(){
        return score;
    }
    String chrom;
    int start;
    int end;
    GenomePosition pos;
    double score;
    List<GeneModelPosition> intra;   // the gene(s) for which this binding site is intrageneic 
    GeneModelPosition[] inter = new GeneModelPosition[4];  // the potentially four genes for which this bibnding site is intergeneic
}
