/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.chipseq.notused;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.List;
import java.util.TreeMap;
import org.rhwlab.db.beans.Gene;
import org.rhwlab.wormbase.GeneModelPosition;

/**
 *
 * @author gevirl
 */
public class Bed {
    public Bed(File file)throws Exception {
        this.file = file;
        this.annotated = new PrintWriter(new File(file.getName() + ".annotated"));
        this.summary = new PrintWriter(new File(file.getName() + ".summary"));
    }
    // return a set of genes that could be associated with one or more binding sites from this bed file
    public void  allPotentialGenes()throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null){
            BindingSite site = new BindingSite();
            site.fromBedFormatEntry(line);
            site.potentialGenes();
            GeneModelPosition[] inter = site.getInter();
            
            // annotate the binding site
            this.annotated.print(line);
            for (GeneModelPosition genePos : inter){
                
                if (genePos != null){
                    Gene gene = genePos.getGene();
                    String geneName = geneName(gene);
                    annotated.printf("\t%s\t%d", gene.getSequenceName(),genePos.getPosition());
                    this.increment(geneName);
                    this.addScore(geneName,site.getScore());
                } else {
                    annotated.printf("\t%s\t%s", ".",",");
                }
            }
            
            // add any intragenic gene(s) to the annotation
            List<GeneModelPosition> intra = site.getIntra();
            for (GeneModelPosition genePos : intra){
                Gene gene = genePos.getGene();
                String geneName = geneName(gene);
                annotated.printf("\t%s\t%d", gene.getSequenceName(),genePos.getPosition());
                this.increment(geneName);
                this.addScore(geneName,site.getScore());
            }
            this.annotated.println();
            this.annotated.flush();
            
            line = reader.readLine();
        }
        reader.close();
        this.annotated.close();
    }
    // increment the peak count for the given gene
    private void increment(String gene){
        Integer count = peakCounts.get(gene);
        if (count == null){
            peakCounts.put(gene, new Integer(1));
        } else {
            peakCounts.put(gene, new Integer(count+1));
        }
    }
    private void addScore(String gene,double val){
        Double v = scores.get(gene);
        if (v == null){
            scores.put(gene, new Double(val));
        } else {
            scores.put(gene, new Double(val+v));
        }
    }
    private String geneName(Gene gene){
        try {
            return String.format("%s\t%s", gene.getSequenceName(),gene.getName());
        } catch (Exception exc){
            exc.printStackTrace();
        }
        return null;
    }
    private void printSummary(){
        for (String gene : peakCounts.keySet()){
            Integer count = peakCounts.get(gene);
            Double score = scores.get(gene);
            summary.printf("%s\t%d\t%f\n", gene,count,score);
        }
        summary.close();
    }
    static public void main(String[] args)throws Exception {
        Bed bed = new Bed(new File(args[0]));
        bed.allPotentialGenes();
        bed.printSummary();
    }
    File file;
    PrintWriter annotated;
    PrintWriter summary;
    TreeMap<String,Integer> peakCounts = new TreeMap<String,Integer>();  // count of peaks for each gene
    TreeMap<String,Double> scores = new TreeMap<String,Double>();
}
