/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.chipseq;

import java.io.File;

/**
 *
 * @author gevirl
 */
public class ModernFile {
    public ModernFile(File file){
        this.file = file;
        parseModernName();
    }
    final private void parseModernName(){
        // remove the bed prefix
        String bedPrefix = "spp.optimal.";
        String fileName = file.getName();
        if (fileName.startsWith(bedPrefix)){
            fileName = fileName.substring(bedPrefix.length());
        }
        String[] tokens = fileName.split("_");
        this.TF = tokens[0].toUpperCase();
        this.strain = tokens[1];
        this.stage = tokens[3];
        
        if (fileName.endsWith("bigBed")){
            this.rep = "Peaks";
        }
        else if (fileName.contains("Rep1")){
            this.rep = "Rep1";
        } 
        else if (fileName.contains("Rep2")){
            this.rep = "Rep2";
        }
        else if (fileName.contains("Rep3")){
            this.rep = "Rep3";
        } 
        else if (fileName.contains("Rep4")){
            this.rep = "Rep4";
        } 
        else if (tokens[4].contains("Input")){
            this.rep = "Input";
        }
        else {
            this.rep = "Rep0";
        }

    }
    public String getTF(){
        return this.TF;
    }
    public String getStrainStage(){
        return String.format(format,strain,stage);
    }
    public String getExperiment(){
        return String.format(format, TF,getStrainStage());
    }
    public String getRepID(){
        String suffix = "subracted";
        if (this.fileName().contains("scaled")){
            suffix = "scaled";
        }
        return String.format("%s_%s_%s_%s_%s",TF,strain,stage,rep,suffix);
    }
    public String fileName(){
        return file.getName();
    }
    public String getRep(){
        return rep;
    }
    public String getBigWigID(){
        String name = file.getName();
        return name.substring(0,name.indexOf("bigWig")-1);
    }
    public String getShortLabel(){
        String[] tokens = file.getName().split("_");
        StringBuilder builder = new StringBuilder();
        for (int i=5 ; i<tokens.length ; ++i){
            builder.append(tokens[i]);
            builder.append("_");
        }
        return builder.toString();
    }
    static String format = "%s_%s";
    String TF;
    String strain;
    String stage;
    String rep;
    File file;
}
