/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.chipseq;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

/**
 *
 * @author gevirl
 */
public class KdistanceGraph {
    public KdistanceGraph(String file)throws Exception {
        map = new TreeMap<>();
        
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null){
            String[] tokens = line.split("\t");
            Double loc;
            loc = 0.5*(Integer.valueOf(tokens[1])+Integer.valueOf(tokens[2]));
            List<Double> list = map.get(tokens[0]);
            if (list == null){
                list = new ArrayList<Double>();
                map.put(tokens[0], list);
            }
            list.add(loc);
            
            
            line = reader .readLine();
        }
        
        for (List list : map.values()){
            Collections.sort(list);
        }
    }
    public List<Double> kDistance(String chromo,int k){
        List<Double> ret = new ArrayList<>();
        
        Double[] locs = map.get(chromo).toArray(new Double[0]);
        for (int i=k ; i<locs.length-k ; ++i){
            int left = i-1;
            int right = i+1;
            double d=0;
            for (int j=0 ; j<k ; ++j){
                double leftD = locs[i]-locs[left];
                double rightD = locs[right]-locs[i];
                if (leftD > rightD){
                    d = rightD;
                    ++right;
                }else {
                    d = leftD;
                    --left;
                }
            }
            ret.add(d);
        }
        Collections.sort(ret);
        return ret;
    }
    TreeMap<String,List<Double>> map;
    
    static public void main(String[] args)throws Exception {
        String fName = String.format("%s_%s.dist", args[1],args[2]);
        PrintStream stream = new PrintStream(fName);
        KdistanceGraph graph = new KdistanceGraph(args[0]);
        List<Double> ds = graph.kDistance(args[1],Integer.valueOf(args[2]));
        for (Double d : ds){
            stream.printf("%f\n", d);
        }
        int asiodhfuisd=0;
    }
}
