/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.chipseq;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;

/**
 *
 * @author gevirl
 */
public class HubTrackDb {
    public HubTrackDb(List<File> raw,List<File> sub,List<File> bigBeds){
        this.scaledWigs = raw;
        this.subtractedWigs = sub;
        this.bigBeds = bigBeds;
        init();
        int ashdfuis=0;
    }
    final public void init(){
        priority = 1.0;
        if (colorMap == null){
            colorMap = new HashMap<>();
            colorMap.put("Peaks","0,0,0");
            colorMap.put("Input","0,0,0");
            colorMap.put("Rep0","255,0,0");
            colorMap.put("Rep1","0,0,255");
            colorMap.put("Rep2","0,255,0");
            colorMap.put("Rep3","0,255,255");
            colorMap.put("Rep4","255,0,255");
            
        }
        for (File file : scaledWigs){
            indexFile(file);
        }
        for (File file : subtractedWigs){
            indexFile(file);
        }
        for (File file : bigBeds){
            indexFile(file);
        }
    }
    private void indexFile(File file){
        ModernFile modFile = new ModernFile(file);
        String tf = modFile.getTF();
        
        TreeMap<String,Experiment> experMap = tfMap.get(tf);
        if (experMap == null){
            experMap = new TreeMap();
            tfMap.put(tf, experMap);
        }
        
        String experName = modFile.getExperiment();
        Experiment exp = experMap.get(experName);
        if (exp == null){
            exp = new Experiment();
            experMap.put(experName,exp);
        }
        
        if(modFile.fileName().endsWith("bigBed")){
            exp.peaks = modFile;
        }
        else {
            String rep = modFile.getRep();
            if (modFile.fileName().endsWith("scaled.bigWig")){
                exp.scaled.put(rep, modFile);
            }
            else {
                exp.subtracted.put(rep, modFile);
            }
        }
    }
    public void writeTo(PrintWriter writer){
        for (String tf : tfMap.keySet()){
            writeTF(tf,writer);
        }
    }
    private void writeTF(String tf,PrintWriter writer){
        writer.printf("track %s\n", tf);
        writer.println("superTrack on");
        writer.printf("shortLabel %s\n",tf);
        writer.printf("longLabel Strains,Stages,Reps for TF: %s\n",tf);
        writer.println("visibility hide");
        writer.printf("priority %f\n", priority);
        priority = priority + delta;        
        writer.println();
        
        TreeMap<String,Experiment> expMap = tfMap.get(tf);
        for (String exp : expMap.keySet()){
            writeExp(tf,exp,expMap.get(exp),writer);
        }
    }
    private void writeExp(String tf,String expName,Experiment exp,PrintWriter writer){
        
        if (exp.peaks != null){
            writeBed(tf,exp.peaks,writer);
        }
        if (!exp.scaled.isEmpty()){
            writeMultiWig(tf,expName,"Scaled",exp.scaled,writer);
        }
        if (!exp.subtracted.isEmpty()){
            writeMultiWig(tf,expName,"Subtracted",exp.subtracted,writer);
        }
        

    }
    private void writeBed(String parent,ModernFile bed,PrintWriter writer){
        String track = String.format("%s_Peaks", bed.getExperiment());
        writer.printf("track %s\n", track);
        writer.printf("parent %s\n", parent);
        writer.printf("shortLabel %s\n",track);
        writer.printf("bigDataUrl %s\n",bed.fileName());
        writer.printf("longLabel Called_Peaks_for_%s\n",bed.getExperiment());

        String c = colorMap.get("Input");
        writer.printf("color %s\n",c);
//        writer.println("maxHeightPixels 128:16:11");
        writer.println("visibility dense");
        writer.println("type bigBed");
        writer.printf("priority %f\n", priority);
        priority = priority + delta;
        writer.println();         
    }
    private void writeMultiWig(String parent,String expName,String type,TreeMap<String,ModernFile> wigs, PrintWriter writer){
        String track = String.format("%s_%s",expName,type);
        writer.printf("track %s\n",track);
        writer.printf("parent %s\n", parent);
        writer.println("container multiWig");
        writer.printf("shortLabel %s\n",track);
        writer.printf("longLabel %s Reps for Experiment: %s\n",type,expName);
        if (type.equals("Subtracted")){
            writer.println("visibility full");
        } else {
            writer.println("visibility hide");
        }
        writer.println("aggregate none"); 
        writer.println("showSubtrackColorOnUi on");
        writer.println("type bigWig 0 1000");
        writer.printf("priority %f\n", priority);
        priority = priority + delta;          
        writer.println(); 
        for (String rep : wigs.keySet()){
            writeRep(track,wigs.get(rep),writer);
        }
    }
    private void writeRep(String parent,ModernFile bigWig,PrintWriter writer){
        String vis = "hide";
        String onoff = "off";
        if (bigWig.fileName().contains("scaled") || bigWig.getRepID().contains("Rep0")){
            vis = "full";
            onoff = "on";
        }        
        writer.printf("track %s\n", bigWig.getRepID());
        writer.printf("parent %s %s\n", parent,onoff);
        writer.printf("shortLabel %s\n",bigWig.getRepID());
        writer.printf("bigDataUrl %s\n",bigWig.fileName());
        writer.printf("longLabel %s\n",bigWig.getRepID());
         writer.println("type bigWig");

        String c = colorMap.get(bigWig.getRep());
        writer.printf("color %s\n",colorMap.get(bigWig.getRep()));
        writer.println("maxHeightPixels 128:40:15");
        

        writer.printf("visibility %s\n",vis);
        writer.println("autoScale on");
      
        writer.println();        
    }
    
    // construct the trackDb.txt file 
    static public void main(String[] args)throws Exception {
        RecursiveFile dir = new RecursiveFile(args[0]);
 //       HubTrackDb db = new HubTrackDb(dir.findFiles("tagAlign_density.bigWig"));
        List<File> beds = dir.findFiles(".bigBed");
        List<File> wigs = dir.findFiles("tagAlign.bigWig");
        List<File> raws = dir.findFiles("scaled.bigWig");
        HubTrackDb db = new HubTrackDb(raws,wigs,beds);
        PrintWriter writer = new PrintWriter(args[1]);
        db.writeTo(writer);
        writer.close();
    }
    double priority;
    double delta = .01;
    static HashMap<String,String> colorMap;
    List<File> subtractedWigs;
    List<File> scaledWigs;
    List<File> bigBeds;
    TreeMap<String,TreeMap<String,Experiment>> tfMap = new TreeMap<>();
    
    class Experiment {
        ModernFile peaks=null;
        TreeMap<String,ModernFile> scaled = new TreeMap<>();
        TreeMap<String,ModernFile> subtracted = new TreeMap<>();
    }
}
