/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.chipseq;

import java.io.File;
import org.rhwlab.formats.GFF3;

/**
 *
 * @author gevirl
 */
public class CombineModernBeds {
    // combine all the binding sites in a set of bed files
    // args[0] - directory with all the modERN ChipSeq beds or an enhanced bed file
    //args[1] - file name of combined output file
    // args[2] - gff3 file - optional, adds target genes if present 
    static public void main(String[] args)throws Exception {
        GFF3 gff = null;
        if (args.length == 3){
            gff = new GFF3(args[2]);
        }
        File dest = new File(args[1]);
        dest.delete();
        
        File dir = new File(args[0]);
        if (dir.isDirectory()){
            File[] bedFiles = dir.listFiles();
            for (File bedFile : bedFiles){
                ModernBed bed = new ModernBed(bedFile);
                bed.parseFilename();
                bed.enhance();
                if (gff!=null){
                    bed.addTargets(gff);
                }
                bed.appendTo(dest);
            }
        } else {
                ModernBed bed = new ModernBed(dir);
                bed.addTargets(gff);
                bed.appendTo(dest);            
        }
    }    
}
