/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.chipseq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.TreeSet;

/**
 *
 * @author gevirl
 */
public class BedGraph {
    String track;
    String fileName;
    TreeMap<String,TreeSet<Entry>> data = new TreeMap<>();
    
    public BedGraph(String file) throws Exception {
        this.fileName = file;
        init();
    }

    final public void init()throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        String line = reader.readLine();
        if (line.startsWith("track")){
            track = line;
            line = reader.readLine();
        }
        while (line != null){
            String[] tokens = line.split("\t| ");
            TreeSet<Entry> chrSet = data.get(tokens[0]);
            if (chrSet == null){
                chrSet = new TreeSet(new Comparator() {

                    @Override
                    public int compare(Object o1, Object o2) {
                        Entry entry1 = (Entry)o1;
                        Entry entry2 = (Entry)o2;
                        return Integer.compare(entry1.start, entry2.start);
                    }
                });
                data.put(tokens[0], chrSet);
            }
            Entry entry = new Entry();
            entry.start = Integer.valueOf(tokens[1]);
            entry.end = Integer.valueOf(tokens[2]);
            entry.value = Double.valueOf(tokens[3]);
            chrSet.add(entry);
            line = reader.readLine();
        }
        reader.close();
    }
    public void toFixedStepWig(String file)throws Exception {
        PrintStream stream = new PrintStream(file);
        stream.println(track);
        for (String chr : data.keySet()){
            TreeSet<Entry> entries = data.get(chr);
            for (Entry entry : entries){
                stream.printf("fixedStep chrom=%s start=%d step=1\n",chr,entry.start);
                for (int i=entry.start ; i<=entry.end ; ++i){
                    stream.println(entry.value);
                }
            }
        }
        stream.close();
    }

    
    class Entry{
        int start;
        int end;
        double value;
        
    }
    public double getValue(String chromo,int pos){
        Entry toFind = new Entry();
        toFind.start = pos;
        double ret = 0.0;
        TreeSet<Entry> chromoEntries = this.data.get(chromo);
        if (chromoEntries != null){
            Entry entry = chromoEntries.floor(toFind);
            if (entry != null){
                if (entry.end > pos){
                    return entry.value;
                }
            }
        }
        return ret;
    }
    public double getAverage(String chromo,int p1,int p2){
        double sum = 0.0;
        for (int p=p1 ; p<=p2 ; ++p){
            sum = sum + getValue(chromo,p);
        }
        return sum/(p2 - p1 + 1);
    }
    public void scaleBedGraph(double scale){
        for (String chr : this.data.keySet()){
            for (Entry entry : this.data.get(chr)){
                entry.value = entry.value*scale;
            }
        }
    }
    public void saveAs(File file)throws Exception {
        PrintStream stream = new PrintStream(file);
        if (track != null){
            stream.println(track);
        }
        for (String chr : this.data.keySet()){
            for (Entry entry : this.data.get(chr)){
                stream.printf("%s\t%d\t%d\t%.2f\n", chr,entry.start,entry.end,entry.value);
            }
        } 
        stream.close();
    }
    static public void main(String[] args ) throws Exception{
        BedGraph bed = new BedGraph(args[0]);
        bed.toFixedStepWig(args[0]+".wig");
        int oisds=0;
    }
}
