/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.beans;
import org.rhwlab.db.MySql;
import java.util.*;
import java.io.*;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.rhwlab.universalimaging.Cell;
import org.rhwlab.universalimaging.Embryo;
/**
 *
 * @author gevirl
 */
public class SulstonEmbryo  implements org.rhwlab.universalimaging.Sulston{
    public SulstonEmbryo()throws Exception {
        this(MySql.getMySql());
    }
    public SulstonEmbryo(MySql db) throws Exception  {
        this(db,null);
    }
    public SulstonEmbryo(MySql db,Integer limit) throws Exception  {
        this.db =db;
        SeriesMetaData md = new SeriesMetaData();
        md.fromSQL(db,sulstonSeries);
        String zipFile = md.getEditZip();            
        SeriesNuclei nucs = new SeriesNuclei("Sulston");
        nucs.readZipFile(new File(zipFile));
        if (limit == null)
            embryo = new SeriesEmbryo(new EmbryoCell("P0",0),nucs,new Integer(md.getEditedTimePoints()),"raw");
        else 
            embryo = new SeriesEmbryo(new EmbryoCell("P0",0),nucs,limit,"raw");
        if (cellFates == null){
            cellFates = new TreeMap<String,String>();
            BufferedReader reader = new BufferedReader(new FileReader("/nfs/waterston/biowolp/sulston/tissues.txt"));
            String line = reader.readLine();
            while (line != null){
                if (!line.equals("")){
                    String[] tokens = line.split(",");
                    cellFates.put(tokens[0].trim(),tokens[1].trim());
                }
                line = reader.readLine();
            }
        }
    }
    public Set<String> getCellFates(String cellName){
        TreeSet<String> ret = new TreeSet<>();
        EmbryoCell cell = this.embryo.getCell(cellName);
        if (cell != null){
            EmbryoCell[] leaves = cell.getLeaves();
            for (EmbryoCell leaf : leaves){
                String fate = SulstonEmbryo.cellFates.get(leaf.getName());
                if (fate != null)
                    ret.add(fate);
            }
        }
        return ret;
    }
    // sulstonize an embryo using this SulstonEmbryo
    // input embryo gets sulstonized
    public boolean sulstonize(Embryo embryo){
        double ratio = sulstonRatio(embryo);
        boolean ret = true;
        for (Cell root : embryo.getRoots()){
            if (sulstonize(root,ratio) == false){
                ret = false;
            }
        }
        return ret;
    }
    // sulstonize a cell and all it's descedents
    // input cell gets sulstonized
    public boolean sulstonize(Cell cell,double averageRatio){
        boolean ret = true;
        Cell[] childrenCells = cell.getChildrenCells();
        if (childrenCells.length>0){
            // sulstonize the children first
            for (int i=0 ; i<childrenCells.length ; ++i){
                if (sulstonize(childrenCells[i],averageRatio) == false){
                    ret = false;
                }
            }
        }

        if (cell.sulstonize(this,averageRatio) == false){
            ret = false;
        }
        return ret;
    }
    // use regression of cell times to determine the average time ratio between the given embryo and the sulton embryo
    // uses cells from this embryo that are not leaves and not roots
    public double sulstonRatio(Embryo embryo){
        SimpleRegression reg = new SimpleRegression(false);
        for (Cell rootCell : embryo.getRoots()){
            TreeSet<EmbryoCell> cells = ((EmbryoCell)rootCell).getAllCells();
            for (EmbryoCell cell : cells){
                if ((!cell.isLeaf())&&(!cell.isRoot())){
                    int cellTime = cell.getEndTime() - cell.getStartTime();
                    EmbryoCell sulstonCell = this.embryo.getCell(cell.getName());
                    int sulstonTime=0;
                    if (sulstonCell != null){
                    try {
                        sulstonTime = sulstonCell.getEndTime() - sulstonCell.getStartTime();
                    } catch (Exception exc){
                        int jsndfisr=0;
                    }
                    reg.addData(cellTime, sulstonTime);
                    }
                    }
                }
            }
        return reg.getSlope();
    }    
    public boolean hasChild(String name){
        return embryo.getCell(name)!=null;
    }
    
    // get the leaf count for a given cell 
    public int getLeafCount(String cellName){
        
        EmbryoCell cell = embryo.getCell(cellName);
        ArrayList<EmbryoCell> ts = EmbryoCell.getLeaves(cell);
        return ts.size();
    }
    
    // return a list of ancestors of a given cell
    // the list includes the given cell
    public List<String> ancestors(String cellName) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(cellName);
        
        // stop if this is the root
        String rootName = (String)embryo.getRoot().getUserObject();
        if (rootName.equals(cellName)) return ret;
        
        EmbryoCell cell = embryo.getCell(cellName);
        ArrayList<EmbryoCell> ancestors = cell.getAncestors();
        for (EmbryoCell ancestor : ancestors){
            ret.add(ancestor.getName());
        }
        return ret;
    }

    
    public SeriesEmbryo getEmbryo(){
        return embryo;
    }
    String sulstonSeries = "20081128_sulston";

    static public void main(String[] args){
        try {
            PrintWriter writer = new PrintWriter(System.out);
            MySql db = MySql.getMySql();
            SulstonEmbryo emb = new SulstonEmbryo(db);
 //           emb.getEmbryo().dump(writer);
           
            EmbryoCell[] allcells = emb.getEmbryo().getAllLeaves();
            int n = allcells.length;
            int i=1;
            for (EmbryoCell cell : allcells){
                System.out.printf("%d  %s\n",i,cell.getName());
                ++i;
            }
            
          
          
            List counts = emb.getEmbryo().cellCountByTime();
            for (int j=0 ; i<counts.size() ; ++j){
                System.out.printf("%d,%d\n",j,counts.get(j));
            }
             
            EmbryoCell[] leaves = emb.embryo.getAllLeaves();
            for (EmbryoCell leaf : leaves){
                if (leaf.getEndTime() != 550)
                    leaf.dump(writer);
            }
            int saoidhio=0;
 /*           
            Double[] timesByCount = emb.getEmbryo().timeByCellCounts();
            BufferedReader reader = new BufferedReader(new FileReader(args[0]));
            String line = reader.readLine();
            double total = 0.0;
            int count = 0;
            while(line != null){
                int cellCount = Integer.valueOf(line);
                double value = timesByCount[cellCount];
                total = total + value;
                ++count;
                line = reader.readLine();
                
            }
            System.out.println(total/count);
*/
 /*          
            int i=1;
            EmbryoCell[] roots = emb.embryo.getRoots();
            for (EmbryoCell root : roots){
                ArrayList<EmbryoCell> set = root.getAllCellsBreath();
                for (EmbryoCell cell : set){
   //                 System.out.printf("%d   %s\n",i,cell.getName());
                    System.out.printf("%s\n",cell.getName());
                    ++i;
                }
                int ruf=0;
            }
  */           
            int ashdf=0;
            
        } catch (Exception exc){
            exc.printStackTrace();
        }
        
    }
    static Map<String,String> cellFates;
    MySql db = null;
    SeriesEmbryo embryo;

    @Override
    public Cell getRoot() {
        return (Cell)embryo.getRoot();
    }

    @Override
    public Cell getCell(String cellName) {
        return embryo.getCell(cellName);
    }

    @Override
    public Cell[] getRoots() {
        return embryo.getRoots();
    }

    @Override
    public int maxExpression() {
        return 0;  // there are no expression values in the sulton embryo
    }

    @Override
    public String getID() {
        return this.embryo.getID();
    }
}
