/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.RNASeq;

import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;

/**
 *
 * @author gevirl
 */
public class PCADataSource extends DataSource{
    public PCADataSource(){
        
    }
    public void init(){
        this.firstSampleInRow = new TreeMap<>();
        
        // determine how many samples there are
        int nSamples = 0;
        for (String experiment : this.getExperiments()){
            this.firstSampleInRow.put(experiment,nSamples);
            nSamples = nSamples + this.getExperimentTimes(experiment).length;
        }

        try {
            // build a set of non zero features
            TreeSet<String> nonZeroFeatures = new TreeSet<>();
            for (String experiment : this.getExperiments()){
                ExperimentDataSource expSource = this.getExperimentSource(experiment);
                Set<String> expFeatures = expSource.getFeatures();
                for (String feature : expFeatures){
                    double[] d = expSource.getFeatureData(feature);
                    for (double v : d){
                        if (v != 0.0){
                            nonZeroFeatures.add(feature);
                            break;
                        }
                    }
                }
            }
            // build the matrix of all samples for PCA
            int nFeatures = nonZeroFeatures.size();
            RealMatrix m = new Array2DRowRealMatrix(nSamples,nFeatures);   
            int col=0;
            for (String feature : nonZeroFeatures){
                int row = 0;
                for (String experiment : this.getExperiments()){
                    double[] d = super.getExpFeatureData(experiment, feature);
                    for (int i=0 ; i<d.length ; ++i){
                        m.setEntry(row, col, d[i]);
                        ++row;
                    }
                }
                ++col;
            }
            
            pca = new PCA(m);
            X = pca.getTransformedDataMatrix();
            
        } catch (Exception exc){
            exc.printStackTrace();
        }
    }
    public Set<String> getFeatures(){
        TreeSet<String> ret = new TreeSet<>();
        for (int c=0 ; c<X.getColumnDimension() ; ++c){
            ret.add(String.format("PC_%d",c));
        }
        return ret;
    }
    public double[] getExpFeatureData(String experiment,String feature){
        double[] ret = new double[this.getExperimentTimes(experiment).length];
        
        int col = Integer.parseInt(feature.substring(3));
        int firstRow = this.firstSampleInRow.get(experiment);
        int lastRow = firstRow + ret.length;
        int i=0;
        for (int row = firstRow  ; row < lastRow ; ++row){
            ret[i] = X.getEntry(row, col);
            ++i;
        }
        
        return ret;
    }
    TreeMap<String,Integer> firstSampleInRow;
    PCA pca;
    RealMatrix X;  // samples by PCAs
}
