/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.RNASeq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.jdom2.Element;

/**
 *
 * @author gevirl
 */
// data structure to hold all the data in a kde file for easy retrieval
public class KdeFile {
    public KdeFile(){
        
    }
    public KdeFile(String file)throws Exception {
        readFile(file);
    }
    public KdeFile(Element ele)throws Exception{
        if (ele != null){
            String file = ele.getAttributeValue("file");
            if (file != null){
                readFile(file);   
            }
        }        
    }
    // reads file and adds the data to this object
    private void  readFile(String kde)throws Exception{
        File kdeFile = new File(kde);
        name = kdeFile.getName();
        BufferedReader reader = new BufferedReader(new FileReader(kdeFile));
        String line = reader.readLine();
        String[] headers = line.split(",");
        
        line = reader.readLine();
        while (line != null){
            String[] tokens = line.split(",");
            HashMap<String,Double> dataMap = new HashMap<>();
            for (int i=1 ; i<tokens.length;++i){
                dataMap.put(headers[i], new Double(tokens[i]));
            }
            map.put(tokens[0],dataMap);
            line = reader.readLine();
        }
        reader.close();
    }
    public String[] getVariables(){
        return map.keySet().toArray(new String[0]);
    }
    public Double getValue(String variable,String type){
        HashMap<String,Double> varMap = map.get(variable);
        if (varMap == null){
            return null;
        }
        return varMap.get(type);
    }
    public double[] getValues(String prefix,String type){
        ArrayList<Double> ret = new ArrayList<>();
        int i = 0;
        HashMap<String,Double> valueMap = map.get(String.format("%s_%d",prefix,i));
        while (valueMap != null){
            ret.add(valueMap.get(type));
            ++i;
            valueMap = map.get(String.format("%s_%d",prefix,i));
        }
        double[] retArray = new double[ret.size()];
        for (i=0 ; i<retArray.length ; ++i){
            retArray[i] = ret.get(i);
        }
        return retArray;
    }
    public String getName(){
        return name;
    }
    // combine a kdefile with this one
    public void combine(KdeFile other){
        map.putAll(other.map);
    }
    // builds the set of variable prefixes that do not contain a given fragment
    public Set<String> getPrefixesExcluding(String fragment){
        TreeSet<String> ret = new TreeSet<>();
        
        for (String var : map.keySet()){
            if (!var.contains(fragment)){
                int index = var.lastIndexOf('_');
                String prefix = var.substring(0, index);
                ret.add(prefix);
            }
        }
        
        return ret;
    }
    public Set<String> getPrefixesEndingWith(String fragment){
        TreeSet<String> ret = new TreeSet<>();

        for (String var : map.keySet()){
            if (var.endsWith(fragment)){
                int index = var.lastIndexOf('_');
                String prefix = var.substring(0, index);
                ret.add(prefix);
            }
        }
        return ret;
    }
    public Set<String> getVariablesContaining(String fragment){
        TreeSet<String> ret = new TreeSet<>();

        for (String var : map.keySet()){
            if (var.contains(fragment)){
                ret.add(var);
            }
        }
        return ret;
    }        
    public Set<String> allPrefixes(){
        TreeSet<String> ret = new TreeSet<>();
        
        for (String var : map.keySet()){
            int index = var.lastIndexOf('_');
            String prefix = var.substring(0, index);
            ret.add(prefix);
        }
        
        return ret;        
    }
    public RealMatrix asMatrix(){
        RealMatrix ret = null;
        Set<String> prefixes = this.allPrefixes();
        int row = 0;
        for (String prefix : prefixes){
            double[] dataRow = this.getValues(prefix, "Mode");
            if (ret == null){
                ret = new Array2DRowRealMatrix(prefixes.size(),dataRow.length);
            }
            ret.setRow(row, dataRow);
            ++row;
        }
        return ret;
    }
    public void setFile(Object f) throws Exception {
        if (f instanceof List){
            for (Object obj : (List)f){
                this.readFile((String)obj);
            }
        } else {
            this.readFile((String)f);
        }
    }
    String name;
    HashMap<String,HashMap<String,Double>> map = new HashMap<>();
}
