/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.transform;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.rhwlab.LMS.dataframe.DataSet;

/**
 *
 * @author gevirl
 */
// used the R version of UMAP
public class Umap implements Transform {

    @Override
    public DataSet xform(DataSet in,Normalization norm) {
        String userDir = System.getProperty("user.dir");
        long time = System.currentTimeMillis();
        String base = in.toString() + "_" + Long.toString(time);
        File infile = new File(userDir, base  + ".df");
        File outfile = new File(userDir,base + ".umap");
        File errFile = new File(userDir,base+".err");
        File stdoutFile = new File(userDir,base+".out");
        try {
            in.saveAs(infile, null);
            ArrayList<String> cmdList = new ArrayList<>();
            cmdList.add("/net/waterston/vol9/R/run_umap.sh");
            cmdList.add(infile.getPath());
            cmdList.add(outfile.getPath());
            ProcessBuilder pb = new ProcessBuilder(cmdList);
            pb.redirectError(errFile);
            pb.redirectOutput(stdoutFile);
            pb.start();
            pb.wait();
        } catch (Exception exc) {
            exc.printStackTrace();
        }

        return null;
    }

    public String toString() {
        return "UMAP";
    }

    static public void main(String[] args) throws Exception {
        Umap umap = new Umap();
        umap.xform(null,null);
    }
}
