/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.transform;

import org.rhwlab.LMS.dataframe.DataFrame;
import org.rhwlab.LMS.dataframe.DataSet;

/**
 *
 * @author gevirl
 */
public class ColumnSumTo1 implements Normalization {

    @Override
    public void normalize(double[][] x) {
        int nCols = x[0].length;
        
        for (int c = 0; c < nCols; ++c) {
            double s = 0.0;
            for (int r = 0; r < x.length; ++r) {
                s = s + x[r][c];
            }
            if (s != 0) {
                for (int r = 0; r<x.length; ++r) {
                    x[r][c] = x[r][c] / s;
                }
            }
        }
    }

    @Override
    public String toString() {
        return "ColumnSumTo1";
    }

    @Override
    public DataSet normalize(DataSet in) {
        double[][] x = in.getAsDouble();
        normalize(x);

        // add the new columns to the df
        DataFrame df = in.getDataFrame();
        String[] colNames = in.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            colNames[i] = "ColSum1" + colNames[i];
        }
        int[] max1Cols = df.addColumns(x, colNames);
        DataSet ds = new DataSet("ColSum1" + in.toString(), df, max1Cols, in.getAttributes().toArray(new String[0]));
        for (String attr : in.getAttributes()) {
            for (int i = 0; i < in.getColumns().length; ++i) {
                String value = in.getAttribute(attr, i);
                ds.setAttribute(attr, i, value);
            }
        }
        // duplicate the colum attributes in the new dataset
        return ds;
    }

}
