/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.algorithm;

import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.clustering.FuzzyKMeansClusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.rhwlab.LMS.dataframe.LabeledClusterable;
import org.rhwlab.LMS.dataframe.investigator.Clustering;

/**
 *
 * @author gevirl
 */
public class Fuzzy implements ClusterAlgorithm {
    JPanel parameterPanel = new JPanel();
    JTextField kField = new JTextField("      ");
    JTextField fuzzyField = new JTextField("      ");
    JTextField iterField = new JTextField("      ");
    
    public Fuzzy(){
        
        GroupLayout layout = new GroupLayout(parameterPanel);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        parameterPanel.setLayout(layout);
        
        JLabel kLabel = new JLabel("# of Clusters");
        JLabel fuzzyLabel = new JLabel("Fuzziness");
        JLabel iterLabel = new JLabel("Iterations");
        
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        parameterPanel.setLayout(layout);
        
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(kLabel).addComponent(fuzzyLabel).addComponent(iterLabel));
        hGroup.addGroup(layout.createParallelGroup().addComponent(kField).addComponent(fuzzyField).addComponent(iterField));
        layout.setHorizontalGroup(hGroup);
        
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(kLabel).addComponent(kField));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(fuzzyLabel).addComponent(fuzzyField));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(iterLabel).addComponent(iterField));
        layout.setVerticalGroup(vGroup);    
    }
    
    @Override
    public JPanel getParameterPanel() {
        return parameterPanel;
    }

    @Override
    public Clustering cluster(String dsname, double[][] x, DistanceMeasure m, String norm) {
        ArrayList<Clusterable> collect = new ArrayList<>();
        int i=0;
        for (double[] row : x){
            collect.add(new LabeledClusterable(row,i));
            ++i;
        }          
        int nClusters = Integer.valueOf(this.kField.getText().trim());      
        double fuzziness = Double.valueOf(fuzzyField.getText().trim());
        int iterations = Integer.valueOf(iterField.getText().trim());
        FuzzyKMeansClusterer clusterer = new FuzzyKMeansClusterer(nClusters,fuzziness,iterations,m);
        List<CentroidCluster<Clusterable>> list = clusterer.cluster(collect);
        RealMatrix mat = clusterer.getMembershipMatrix();
        
        // report the clusters
        int c = 1;
        for (CentroidCluster<Clusterable> cluster : list){
            
            for (Clusterable point : cluster.getPoints()){
                System.out.printf("%d ", c);
                LabeledClusterable labeled = (LabeledClusterable)point;
                int row = labeled.getLabel();
                double[] p = mat.getRow(row);
                for (int j=0 ; j<p.length ; ++j){
                    System.out.printf("%.3f,",p[j]);
                }
                System.out.println();
            }
            ++c;        
                    
        }
   
        String s = String.format("Fuzzy ; %s ; %s ; %s ; %s ; %s ; %s",dsname,norm,m.toString(),kField.getText().trim(),fuzzyField.getText().trim(),iterField.getText().trim());
        Clustering ret = new Clustering(s,mat);
        return ret;
    }
    @Override
    public String toString(){
        return "FuzzyKmeans";
    }    
    
}
