/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator.algorithm;

import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.clustering.DBSCANClusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.rhwlab.LMS.dataframe.LabeledClusterable;
import org.rhwlab.LMS.dataframe.investigator.Clustering;

/**
 *
 * @author gevirl
 */
public class DBSCAN implements ClusterAlgorithm {
    JPanel parameterPanel = new JPanel();
    JTextField epsilonField = new JTextField();
    JTextField minPtsField = new JTextField();
    JLabel epsilonLabel = new JLabel("Epsilon")   ;
    JLabel minPtsLabel = new JLabel("minPts");
    
    public DBSCAN(){
        
        GroupLayout layout = new GroupLayout(parameterPanel);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        parameterPanel.setLayout(layout);
        
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup().addComponent(epsilonLabel).addComponent(minPtsLabel));
        hGroup.addGroup(layout.createParallelGroup().addComponent(epsilonField).addComponent(minPtsField));
        layout.setHorizontalGroup(hGroup);
        
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(epsilonLabel).addComponent(epsilonField));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(minPtsLabel).addComponent(minPtsField));
        layout.setVerticalGroup(vGroup);        
    }

    @Override
    public JPanel getParameterPanel() {
        return parameterPanel;
    }

    @Override
    public Clustering cluster(String dsname, double[][] x, DistanceMeasure m,String norm) {
        ArrayList<Clusterable> collect = new ArrayList<>();
        int i=0;
        for (double[] row : x){
            collect.add(new LabeledClusterable(row,i));
            ++i;
        }
        double eps = Double.valueOf(this.epsilonField.getText().trim());
        int minPts = Integer.valueOf(this.minPtsField.getText().trim());
        DBSCANClusterer clusterer = new DBSCANClusterer(eps,minPts,m);

        List<Cluster> clusters = clusterer.cluster(collect);
        int nClusters = clusters.size();
        System.out.printf("Number of Clusters: %d\n",clusters.size());
        int[] index = new int[x.length];
        int cl=0;
        for (Cluster cluster : clusters){
            for (Object obj : cluster.getPoints()){
                LabeledClusterable clusterable = (LabeledClusterable)obj;
                index[clusterable.getLabel()] = cl;
            }
            ++cl;
        }    
        String s = String.format("DBSCAN ; %s ; %s ; %s ; epsilon:%s ; minPts:%s ; nClusters %d",
                dsname,norm,m.toString(),this.epsilonField.getText().trim(),this.minPtsField.getText().trim(),nClusters);
        Clustering ret = new Clustering(s,index);
        return ret;
    }
    
    public String toString(){
        return "DBSCAN";
    }
    
}
