/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.math.plot.Plot2DPanel;
import org.math.plot.plots.ColorBrewer;
import org.rhwlab.LMS.dataframe.DataFrame;
import org.rhwlab.LMS.dataframe.DataSet;
import org.rhwlab.LMS.dataframe.FileDataFrame;
import org.rhwlab.LMS.dataframe.GeneScatterPlot;
import org.rhwlab.LMS.dataframe.MouseNotifyingCanvas;
import org.rhwlab.LMS.dataframe.investigator.algorithm.Silhouette;

/**
 *
 * @author gevirl
 */
public class InvestigatorFrame extends JFrame implements Observer{

    Investigation invest;
    protected DataSetAttributesPanel dsaPanel;
    protected DataSelectionPanel dataSelectionPanel;
    JFileChooser fileChooser;
    JFileChooser dirChooser;
    MouseNotifyingCanvas canvas;
    protected ClusteringListPanel clusteringListPanel;
    ClusteringDefinitionPanel clusteringDefPanel;
    RowsInClusterPanel rowsPanel;
    JList clusterList;
    JButton searchButton = new JButton("Search");
    JTextField searchField = new JTextField("      ");
    JTextField threshField = new JTextField("      ");
    JLabel totalGenes = new JLabel("   ");
    JLabel genesInClusters = new JLabel("   ");
    JLabel uniqueGenesInClusters = new JLabel("   ");
    JCheckBox uncluster = new JCheckBox("Unclustered");

    String[] allRowNames = new String[0];
    String[] searchGenes = new String[0];

    protected double characterizationThresh = 1.0;
    
    public InvestigatorFrame() throws Exception {
        this(null);
        int uhsaiufhuiasdf=0;
    }

    public InvestigatorFrame(Investigation in) throws Exception {
        dsaPanel = new DataSetAttributesPanel();
//        double minTPM = 15.0;
        //       double minTPM = 0.0;
        Dimension dm = searchField.getPreferredSize();
        dm.width = 3 * dm.width;
        searchField.setMaximumSize(dm);
        dirChooser = new JFileChooser();
        dirChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        uncluster.setSelected(false);
        this.invest = new Investigation();
        if (in != null) {
            this.invest = in;
            this.allRowNames = invest.getDataRowNames();
        }
//        invest = new Investigation(minTPM);
//        allGenes = invest.getDataRowNames();

        this.getContentPane().setLayout(new BorderLayout());

        rowsPanel = new RowsInClusterPanel(this, allRowNames,dsaPanel);
        this.add(rowsPanel, BorderLayout.EAST);

        // build the center panel
        canvas = new MouseNotifyingCanvas();
        canvas.getGrid().setVisible(false);
        Plot2DPanel plot = new Plot2DPanel(canvas);
        plot.plotCanvas.setNotable(true);
        plot.plotCanvas.setNoteCoords(false);
        plot.addLegend("SOUTH");
        this.add(plot, BorderLayout.CENTER);

        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        this.add(southPanel, BorderLayout.SOUTH);
        dataSelectionPanel = new DataSelectionPanel(this,dsaPanel);
        clusteringListPanel = new ClusteringListPanel(this,dsaPanel);
        invest.addObserver(clusteringListPanel);
        clusteringDefPanel = new ClusteringDefinitionPanel(invest);
        dataSelectionPanel.getDataSetBox().addObserver(clusteringDefPanel);
        dataSelectionPanel.getDataFrameBox().addObserver(clusteringListPanel);
        dataSelectionPanel.getDataFrameBox().addObserver(this);
        southPanel.add(clusteringDefPanel.getPanel(), BorderLayout.EAST);
        southPanel.add(clusteringListPanel, BorderLayout.CENTER);
        southPanel.add(dataSelectionPanel, BorderLayout.WEST);

        clusterList = new JList();
        JScrollPane clusterScroll = new JScrollPane(clusterList);
        clusterList.addListSelectionListener(new ListSelectionListener() {
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    updateCanvas();
                    String selCl = (String) clusterList.getSelectedValue();
                    if (selCl != null) {
                        int sel = Integer.valueOf(selCl.split("-")[0].trim()) - 1;
                        Clustering clustering = clusteringListPanel.getSelectedClustering();
                        int[][] clusters = clustering.getClusters();
                        ChangeEvent event = new ChangeEvent(clusters[sel]);
                        rowsPanel.stateChanged(event);
 //                       ClusterBoxAndWhiskerPanel chartPanel = new ClusterBoxAndWhiskerPanel(
 //                               String.format("Cluster %d ; Genes %d ; Probability %.2f", sel + 1, clusters[sel].length, clustering.getProbabilityThreshold()), dataSetPanel.getSelectedDataSet(), clusters[sel], "Time", "Series");
                        BoxAndWhiskerPanel chartPanel = new BoxAndWhiskerPanel(
                                String.format("Cluster %d ; Genes %d ; Probability %.2f", sel + 1, clusters[sel].length, clustering.getProbabilityThreshold()), dataSelectionPanel.getSelectedDataSet(), clusters[sel], dsaPanel);
                        JFrame plotframe = new SavableImageFrame();
                        plotframe = new JFrame();
                        plotframe.getContentPane().setLayout(new BorderLayout());
                        plotframe.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
                        plotframe.getContentPane().removeAll();
                        plotframe.add(chartPanel, BorderLayout.CENTER);
                        plotframe.setVisible(true);
                        plotframe.pack();
                        plotframe.setSize(900, 600);

                        Silhouette silh = clusteringListPanel.getSelectedSilhouette();
                        if (silh != null) {
                            JFrame silhFrame = new JFrame();
                            silhFrame.setTitle(String.format("%s Cluster:%d", silh.toString(), sel + 1));
                            SilhouettePanel panel = new SilhouettePanel(silh, clustering, sel);
                            silhFrame.getContentPane().add(panel);
                            silhFrame.pack();
                            silhFrame.setSize(500, 900);
                            silhFrame.setVisible(true);
                            silhFrame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
                        }

                    }
                }
            }
        });

        JPanel west = new JPanel();
        west.setLayout(new BoxLayout(west, BoxLayout.Y_AXIS));
        west.add(Box.createVerticalStrut(5));

        west.add(clusterScroll);
        west.add(Box.createVerticalStrut(5));
        this.add(west, BorderLayout.WEST);

        // build the searching panel
        JPanel north = new JPanel();
        GroupLayout layout = new GroupLayout(north);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        north.setLayout(layout);
        JLabel geneLabel = new JLabel("Enter a gene name: ");
        JLabel threshLabel = new JLabel("Prob Threshold: ");
        JLabel totalGenesLabel = new JLabel("Total Genes: ");
        
        //       JLabel genesInClusterLabel = new JLabel("Genes in Multiple Clusters: ");
        JLabel uniqueGenesLabel = new JLabel("Genes in Clusters: ");
        JButton update = new JButton("Update");
        update.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                updateClusterList();
            }
        });
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        hGroup.addComponent(geneLabel).addComponent(searchField).addComponent(searchButton).addGap(20).
                addComponent(threshLabel).addComponent(threshField).addComponent(update).addGap(20).
                addComponent(uncluster).addGap(20).
                //                addComponent(genesInClusterLabel).addComponent(this.genesInClusters).addGap(20).
                addComponent(uniqueGenesLabel).addComponent(this.uniqueGenesInClusters).addComponent(dsaPanel);
        layout.setHorizontalGroup(hGroup);

        GroupLayout.ParallelGroup vGroup = layout.createParallelGroup();
        vGroup.addComponent(geneLabel).addComponent(searchField).addComponent(searchButton).
                addComponent(threshLabel).addComponent(threshField).addComponent(update).
                addComponent(uncluster).
                //                addComponent(genesInClusterLabel).addComponent(this.genesInClusters).
                addComponent(uniqueGenesLabel).addComponent(this.uniqueGenesInClusters).addComponent(dsaPanel);
        layout.setVerticalGroup(vGroup);
        this.add(north, BorderLayout.NORTH);

        searchButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                searchGene();
            }
        });
        buildMenu();
    }

    private void searchGene() {
        DataFrame df = this.getSelectedDataFrame();
        String genes = searchField.getText().trim();
        canvas.clearCrossHairs();
        searchGenes = genes.split(",|\t|\n| ");
        int nFound = 0;
        for (String token : searchGenes) {
            Integer row = df.find(df.getHeaders().get(invest.getRownameColumn()), token);
            if (row != null) {
                DataSet axis = this.dataSelectionPanel.getSelectedAxes();
                double[] xy = axis.getRow(row);

                canvas.setCrossHair(xy);
                ++nFound;
            }

            /*            
                int[] proj = canvas.project(xy);
                canvas.mousePressed(new MouseEvent(this, MouseEvent.MOUSE_PRESSED, System.currentTimeMillis(), MouseEvent.BUTTON1_MASK, proj[0], proj[1], 1, false));
                canvas.mouseReleased(new MouseEvent(this, MouseEvent.MOUSE_RELEASED, System.currentTimeMillis(), MouseEvent.BUTTON1_MASK, proj[0], proj[1], 1, false));
                canvas.mouseClicked(new MouseEvent(this, MouseEvent.MOUSE_CLICKED, System.currentTimeMillis(), MouseEvent.BUTTON1_MASK, proj[0], proj[1], 1, false));
             */
        }
        System.out.printf("Genes found: %d\n", nFound);
        this.updateClusterList();
        this.updateCanvas();
    }


    final void buildMenu() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);

        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);


        
        JMenuItem openItem = new JMenuItem("Open Investigation xml");
        fileMenu.add(openItem);
        openItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                FileFilter filter = new FileNameExtensionFilter("Investigation XML", "xml");
                fileChooser = new JFileChooser();
                fileChooser.setFileFilter(filter);
                if (fileChooser.showOpenDialog(InvestigatorFrame.this) == JFileChooser.APPROVE_OPTION) {
                    try {
                        File file = fileChooser.getSelectedFile();
                        invest.init(file);
                        InvestigatorFrame.this.setTitle(file.getPath());
                        allRowNames = invest.getDataRowNames();
 //                       dataSetPanel.setInvestigation(invest);
                        rowsPanel.setGeneNames(allRowNames);
                        updateCanvas();
                        clusteringListPanel.update(invest, null);
                    } catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }

            }
        });
        
        JMenuItem addItem = new JMenuItem("Open a DataFrame");
        fileMenu.add(addItem);
        addItem.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                fileChooser = new JFileChooser();

                if (fileChooser.showOpenDialog(InvestigatorFrame.this) == JFileChooser.APPROVE_OPTION) {
                    try {
                        if (invest != null){
                            File dfFile = fileChooser.getSelectedFile();
                            FileDataFrame df = new FileDataFrame(dfFile);
                            String title = dfFile.getName().replaceAll(".df", "");
                            invest.mergeDataFrame(title, df,getSelectedDataFrame());
 //                           dataSetPanel.stateChanged(null);
                        }
                        updateCanvas();
                        clusteringListPanel.update(invest, null);
                    } catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            }
        });

        JMenuItem saveItem = new JMenuItem("Save DataSet as a DataFrame");
        saveItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
/*                
                String[] choices = new String[invest.dataSets.size()];
                for (int i = 0; i < choices.length; ++i) {
                    choices[i] = invest.dataSets.get(i).toString();
                }
                
                DataSet[] sets = invest.dataSets.get(invest.dfs.get(0)).toArray(new DataSet[0]);
                DataSet set = (DataSet) JOptionPane.showInputDialog(rootPane, "Choose a DataSet", "Save DataSet", JOptionPane.QUESTION_MESSAGE, null, sets, sets[0]);
                if (set == null) {
                    return;
                }
*/
                DataSet set = getSelectedDataSet();
                FileFilter filter = new FileNameExtensionFilter("DataFrame", "df");
                JFileChooser chooser = new JFileChooser();
                chooser.setFileFilter(filter);
                if (chooser.showSaveDialog(InvestigatorFrame.this) == JFileChooser.APPROVE_OPTION) {
                    try {
                        set.saveAs(chooser.getSelectedFile(),null);
                    } catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }                
  
            }
        });
        fileMenu.add(saveItem);

        JMenuItem saveAsItem = new JMenuItem("SaveAs");
        fileMenu.add(saveAsItem);
        saveAsItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (fileChooser == null) {
                    if (invest.getFile() == null) {
                        fileChooser = new JFileChooser();
                    } else {
                        fileChooser = new JFileChooser(invest.getFile().getParentFile());
                    }
                }
                if (fileChooser.showSaveDialog(InvestigatorFrame.this) == JFileChooser.APPROVE_OPTION) {
                    try {
                        invest.saveAs(fileChooser.getSelectedFile());
                    } catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            }
        });

        JMenuItem boxWhisk = new JMenuItem("Save Box/Whisker Plots");
        fileMenu.add(boxWhisk);
        boxWhisk.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = JOptionPane.showInputDialog(
                        InvestigatorFrame.this, "Select Format", "", JOptionPane.QUESTION_MESSAGE, null, ImageIO.getWriterMIMETypes(), null);
                if (obj != null) {
                    if (dirChooser.showSaveDialog(InvestigatorFrame.this) == JFileChooser.APPROVE_OPTION) {
                        File dir = dirChooser.getSelectedFile();
                        Clustering clustering = InvestigatorFrame.this.clusteringListPanel.getSelectedClustering();
                        if (clustering != null) {
                            int[][] clusters = clustering.getClusters();
                            for (int sel = 0; sel < clusters.length; ++sel) {

                                ClusterBoxAndWhiskerPanel chartPanel = new ClusterBoxAndWhiskerPanel(
                                        String.format("Cluster %d ; Genes %d ", sel + 1, clusters[sel].length), dataSelectionPanel.getSelectedDataSet(), clusters[sel], "Time", "Series");
                                JFrame plotframe = new SavableImageFrame();
                                plotframe = new JFrame();
                                plotframe.getContentPane().setLayout(new BorderLayout());
                                plotframe.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
                                plotframe.getContentPane().removeAll();
                                plotframe.add(chartPanel, BorderLayout.CENTER);
                                plotframe.pack();
                                plotframe.setSize(900, 600);
                                String mime = (String) obj;
                                String suffux = mime.split("/")[1];
                                File file = new File(dir, String.format("Cluster%02d.%s", sel + 1, suffux));
                                try {
                                    SavableImageFrame.saveToFile(chartPanel, file, mime);
                                } catch (Exception exc) {
                                    exc.printStackTrace();
                                }
                            }
                        }
                    }
                }
            }
        });

    }

    public void updateClusterList() {
        HashSet<Integer> unique = new HashSet<>();
        DefaultListModel model = new DefaultListModel();
        Clustering clustering = clusteringListPanel.getSelectedClustering();
        if (clustering != null) {
            setThreshold(clustering);
            int[][] clusters = clustering.getClusters();
            int total = 0;
            for (int cl = 0; cl < clusters.length; ++cl) {
                String clLabel = Integer.toString(cl + 1);
                int[] rows = clusters[cl];
                
                String characterization = this.dataSelectionPanel.getSelectedDataSet().characterizeByMeans(rows,characterizationThresh,(String)dsaPanel.getSelectedAttributes().get(0));
                
                // which genes are marked
                TreeSet clusterGenes = new TreeSet<String>();
                for (int row : rows) {
                    clusterGenes.add(allRowNames[row]);
                }
                int nMarked = 0;
                for (String markedGene : this.searchGenes) {
                    if (clusterGenes.contains(markedGene)) {
                        ++nMarked;
                    }
                }
                double pct = (double) nMarked / (double) rows.length;
                model.addElement(String.format("%s - %d %s", clLabel, rows.length,characterization));
                System.out.printf("%s - %.2f\n", clLabel, pct);
                if (cl != clusters.length - 1) {
                    for (int r = 0; r < rows.length; ++r) {
                        unique.add(rows[r]);
                    }
                    total = total + rows.length;
                }
            }
            int unclustered = clusters[clusters.length - 1].length;
            this.clusterList.setModel(model);

            this.uniqueGenesInClusters.setText(Integer.toString(unique.size()));
            this.genesInClusters.setText(Integer.toString(total - unique.size()));
            this.totalGenes.setText(Integer.toString(unique.size() + unclustered));
        }
        updateCanvas();
    }

    private void setThreshold(Clustering clustering) {
        double p = 0.0;
        try {
            p = Double.valueOf(threshField.getText().trim());
        } catch (Exception exc) {

        }
        clustering.setProbabilityThreshold(p);
    }

    public void updateCanvas() {
        DataSet axis = dataSelectionPanel.getSelectedAxes();
        if (axis ==null) return;
        double[][] x = axis.getAsDouble();
        canvas.removeAllPlots();
        canvas.removeAllPlotables();
        String selCl = (String) clusterList.getSelectedValue();
        int sel = -1;
        if (selCl != null) {
            sel = Integer.valueOf(selCl.split("-")[0].trim());
        }
        // is there a clustering selected?
        Clustering clustering = clusteringListPanel.getSelectedClustering();

        int[][] clusters;
        if (clustering == null) {
            // put all the data into a single cluster
            clusters = new int[1][];
            int[] recs = new int[x.length];
            for (int r = 0; r < x.length; ++r) {
                recs[r] = r;
            }
            clusters[0] = recs;

        } else {
            setThreshold(clustering);
            clusters = clustering.getClusters();
        }

        // limit the display to 100 of the largest clusters
        int nc = 100;
        if (clusters.length > nc) {
            Arrays.sort(clusters, new Comparator() {
                @Override
                public int compare(Object o1, Object o2) {
                    Integer i1 = ((int[]) o1).length;
                    Integer i2 = ((int[]) o2).length;
                    return i2.compareTo(i1);
                }
            });
            int[][] temp = new int[nc][];
            for (int i = 0; i < nc; ++i) {
                temp[i] = clusters[i];
            }
            clusters = temp;
        }

        ColorBrewer[] brewers = ColorBrewer.getDivergingColorPalettes(true);
        brewers = ColorBrewer.getQualitativeColorPalettes(true);
        Color[] colors = brewers[0].getColorPalette(clusters.length);

        int c = 0;
        int nclusters = clusters.length;
        if (!uncluster.isSelected()) {
            --nclusters;
        }
        for (int cl = 0; cl < nclusters; ++cl) {
            if (cl == 45) {
                int auisdhfuisd = 0;
            }
            GeneScatterPlot scatter = null;
            String clLabel = Integer.toString(cl + 1);
            double[] centroid = new double[2];
            int[] rows = clusters[cl];
            if (rows.length > 0) {
                String[] labels = new String[rows.length];
                double[][] XY = new double[rows.length][];
                int j = 0;
                for (int r : rows) {
                    XY[j] = new double[2];
                    XY[j][0] = x[r][0];
                    XY[j][1] = x[r][1];
//                    centroid[0] = centroid[0] + x[r][0];
//                    centroid[1] = centroid[1] + x[r][1];
                    labels[j] = allRowNames[r];
                    ++j;
                    //                ++g;
                }
                //               centroid[0] = centroid[0]/rows.length;
                //               centroid[1] = centroid[1]/rows.length;
                if (sel == cl + 1) {
                    scatter = new GeneScatterPlot(clLabel, Color.black, XY, labels);
                } else {
                    scatter = new GeneScatterPlot(clLabel, colors[c], XY, labels);
                }
                centroid = this.getClusterCenter(XY, .1);
            }
            ++c;
//            scatter.addChangeListener(geneDisplayPanel);
            if (scatter != null) {
                canvas.addPlot(scatter);
                canvas.addLabel(clLabel, Color.black, centroid);
            }
        }
        //       nGenes.setText(String.format("Total Genes in Clusters=%d",g));
    }

    private double[] getClusterCenter(double[][] xy, double r) {
        TreeSet<double[]> xSorted = new TreeSet<>(new Comparator() {
            @Override
            public int compare(Object o1, Object o2) {
                double[] v1 = (double[]) o1;
                double[] v2 = (double[]) o2;
                return Double.compare(v1[0], v2[0]);
            }
        });
        TreeSet<double[]> ySorted = new TreeSet<>(new Comparator() {
            @Override
            public int compare(Object o1, Object o2) {
                double[] v1 = (double[]) o1;
                double[] v2 = (double[]) o2;
                return Double.compare(v1[1], v2[1]);
            }
        });

        for (int i = 0; i < xy.length; ++i) {
            xSorted.add(xy[i]);
            ySorted.add(xy[i]);
        }

        int nMax = 0;
        int index = 0;
        for (int i = 0; i < xy.length; ++i) {
            // count lower x neighors
            int xLow = 0;
            double[] lower = xSorted.lower(xy[i]);
            while (lower != null && xy[i][0] - lower[0] < r) {
                lower = xSorted.lower(lower);
                ++xLow;
            }
            // count lower y neighors
            int yLow = 0;
            lower = ySorted.lower(xy[i]);
            while (lower != null && xy[i][1] - lower[1] < r) {
                lower = ySorted.lower(lower);
                ++yLow;
            }
            // count higher x neighors
            int xHigh = 0;
            double[] high = xSorted.higher(xy[i]);
            while (high != null && high[0] - xy[i][0] < r) {
                high = xSorted.higher(high);
                ++xHigh;
            }
            // count lower y neighors
            int yHigh = 0;
            high = ySorted.higher(xy[i]);
            while (high != null && high[1] - xy[i][1] < r) {
                high = ySorted.higher(high);
                ++yHigh;
            }

            int n = xLow + xHigh + yLow + yHigh;
            if (n > nMax) {
                nMax = n;
                index = i;
            }
        }
        return xy[index];
    }

    public Investigation getInvestigation() {
        return this.invest;
    }

    public DataSet getSelectedDataSet() {
        return this.dataSelectionPanel.getSelectedDataSet();
    }

    public DataFrame getSelectedDataFrame(){
        return this.dataSelectionPanel.getSelectedDataFrame();
    }
    public int getSelectedCluster() {
        String selCl = (String) clusterList.getSelectedValue();
        if (selCl != null) {
            return Integer.valueOf(selCl.split("-")[0].trim());
        }
        return -1;
    }


    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof DataFrameBox){
            DataFrameBox box = (DataFrameBox)o;
            this.allRowNames = invest.getDataRowNames(box.getSelected());
            this.rowsPanel.setGeneNames(allRowNames);
        }
    }

    static public void main(String[] args) throws Exception {

        InvestigatorFrame frame = new InvestigatorFrame();
        frame.pack();
        frame.setSize(1200, 900);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setVisible(true);
        int iuhsuhs=0;
    }    
}
