/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator;

import org.rhwlab.LMS.dataframe.investigator.transform.Transform;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.rhwlab.LMS.dataframe.DataFrame;
import org.rhwlab.LMS.dataframe.DataSet;
import org.rhwlab.LMS.dataframe.investigator.transform.Normalization;
import org.rhwlab.LMS.dataframe.investigator.transform.NormalizationBox;
import org.rhwlab.LMS.dataframe.investigator.transform.TransformBox;

/**
 *
 * @author gevirl
 */
public class DataSelectionPanel extends JPanel  {

    Investigation inv;
    InvestigatorFrame invFrame;
    DataSetAttributesPanel dsaPanel;
    
    DataFrameBox dataFrameBox= new DataFrameBox();
    DataSetBox dataSetBox= new DataSetBox();
    NormalizationBox normBox=new NormalizationBox();
    TransformBox xformBox=new TransformBox();
    
    AxesBox axesBox = new AxesBox();

    public DataSelectionPanel(InvestigatorFrame invFrame,DataSetAttributesPanel dsaPanel) {
        int isudfudgfuy=0;
        this.invFrame = invFrame;
        this.inv = invFrame.getInvestigation();        
        this.dsaPanel = dsaPanel;
        
        inv.addObserver(dataFrameBox);
        dataFrameBox.addObserver(dataSetBox);
        dataSetBox.addObserver(dsaPanel);
        dataSetBox.addObserver(axesBox);
/*        
        dataSetBox.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                dataSetBox.getSelectedItem();
                dsaPanel.setDataSet((DataSet)dataSetBox.getSelectedItem());
            }
        });

*/
        GroupLayout layout = new GroupLayout(this);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        this.setLayout(layout);

        JLabel frameLabel = new JLabel("DataFrame");
        JLabel dataSetLabel = new JLabel("DataSets");
        JLabel xformLabel = new JLabel("Transforms");
        JLabel axesLabel = new JLabel("Axes");
        JLabel normLabel = new JLabel("Normalization");

        JButton xformButton = new JButton("Transform");
        xformButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                transform();
            }
        });

        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        hGroup.addGroup(layout.createParallelGroup()
                .addComponent(frameLabel)
                .addComponent(axesLabel)
                .addComponent(dataSetLabel)
                .addComponent(normLabel)
                .addComponent(xformLabel));
        hGroup.addGroup(layout.createParallelGroup()
                .addComponent(dataFrameBox.getBox())
                .addComponent(axesBox)
                .addComponent(dataSetBox.getBox())
                .addComponent(normBox)
                .addComponent(xformBox)
                .addComponent(xformButton));
        layout.setHorizontalGroup(hGroup);

        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
         vGroup.addGroup(layout.createParallelGroup(Alignment.BASELINE).addComponent(frameLabel).addComponent(dataFrameBox.getBox()));
        vGroup.addGroup(layout.createParallelGroup(Alignment.BASELINE).addComponent(axesLabel).addComponent(axesBox));
        vGroup.addGroup(layout.createParallelGroup(Alignment.BASELINE).addComponent(dataSetLabel).addComponent(dataSetBox.getBox()));
        vGroup.addGroup(layout.createParallelGroup(Alignment.BASELINE).addComponent(normLabel).addComponent(normBox));        
        vGroup.addGroup(layout.createParallelGroup(Alignment.BASELINE).addComponent(xformLabel).addComponent(xformBox));
        vGroup.addComponent(xformButton);
        layout.setVerticalGroup(vGroup);

//        stateChanged(null);

        axesBox.addItemListener(new ItemListener() {
            @Override
            public void itemStateChanged(ItemEvent e) {
                invFrame.updateCanvas();
            }
        });
    }

    
    private void transform() {
        Transform xform = (Transform) xformBox.getSelectedItem();
        Normalization norm = (Normalization)normBox.getSelectedItem();
        DataSet set = xform.xform((DataSet)dataSetBox.getBox().getSelectedItem(),norm);
        if (set != null) {
            inv.addDataSet(set);
//            stateChanged(null);
        }
    }
/*
    @Override
    public void stateChanged(ChangeEvent e) {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        if (inv != null) {
            for (DataSet ds : inv.getDataSets()) {
                model.addElement(ds);
            }
        }
        this.dataSetBox.setModel(model);

        model = new DefaultComboBoxModel();
        if (inv != null) {
            for (DataSet ds : inv.getDataSets()) {
                if (ds.getColumns().length == 2) {
                    model.addElement(ds);
                }
            }
        }

        axesBox.setModel(model);
    }
*/
    public DataSet getSelectedDataSet() {
        return (DataSet) dataSetBox.getBox().getSelectedItem();
    }

    public DataFrame getSelectedDataFrame(){
        return getDataFrameBox().getSelected();
    }
    public void setInvestigation(Investigation invest) {
        this.inv = invest;
//        stateChanged(null);
    }

    public DataSet getSelectedAxes() {
        return (DataSet) this.axesBox.getSelectedItem();
    }

    public DataSetBox getDataSetBox(){
        return this.dataSetBox;
    }
    
    public DataFrameBox getDataFrameBox(){
        return this.dataFrameBox;
    }
}
