/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.rhwlab.LMS.dataframe.DataSet;
import org.rhwlab.LMS.dataframe.investigator.algorithm.ClusterAlgorithm;
import org.rhwlab.LMS.dataframe.investigator.algorithm.DBSCAN;
import org.rhwlab.LMS.dataframe.investigator.algorithm.DPC;
import org.rhwlab.LMS.dataframe.investigator.algorithm.Fuzzy;
import org.rhwlab.LMS.dataframe.investigator.algorithm.KMeans;
import org.rhwlab.LMS.dataframe.investigator.measure.AngleMeasure;
import org.rhwlab.LMS.dataframe.investigator.measure.JensenShannonMetric;
import org.rhwlab.LMS.dataframe.investigator.measure.LabeledManhattan;
import org.rhwlab.LMS.dataframe.investigator.measure.NamedEuclidean;
import org.rhwlab.LMS.dataframe.investigator.measure.Spearman;
import org.rhwlab.LMS.dataframe.investigator.transform.LenTo1;
import org.rhwlab.LMS.dataframe.investigator.transform.MaxTo1;
import org.rhwlab.LMS.dataframe.investigator.transform.Normalization;
import org.rhwlab.LMS.dataframe.investigator.transform.NormalizationBox;
import org.rhwlab.LMS.dataframe.investigator.transform.Null;
import org.rhwlab.LMS.dataframe.investigator.transform.SumTo1;
import org.rhwlab.LMS.dataframe.investigator.transform.Zscore;

/**
 *
 * @author gevirl
 */
public class ClusteringDefinitionPanel extends Observable implements Observer {

    JPanel mainPanel = new JPanel();
    GroupLayout layout;

    NormalizationBox normalizationBox;
    JComboBox algorithmBox;
    JComboBox distanceBox;
    JLabel dsValue = new JLabel("");

    JLabel dsLabel = new JLabel("DataSet");
    JLabel normalizationLabel = new JLabel("Normalization");
    JLabel algorithmLabel = new JLabel("Algorithm");
    JLabel distanceLabel = new JLabel("DistanceMeasure");

    JPanel parametersPanel = new JPanel();

    JButton clusterButton = new JButton("Cluster");

    Normalization[] normalizations = {new Null(), new MaxTo1(), new SumTo1(), new Zscore(), new LenTo1()};

    Clustering clustering;
    DataSet ds;
    Investigation inv;
    
    public ClusteringDefinitionPanel(Investigation inv) {
        this.inv = inv;
        layout = new GroupLayout(mainPanel);
        mainPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);

        mainPanel.setBorder(BorderFactory.createLineBorder(Color.black, 3));

        DefaultComboBoxModel algModel = new DefaultComboBoxModel();
        algModel.addElement(new KMeans());
        algModel.addElement(new Fuzzy());
        algModel.addElement(new DBSCAN());
        algModel.addElement(new DPC());
        algorithmBox = new JComboBox(algModel);

        DefaultComboBoxModel distModel = new DefaultComboBoxModel();
        distModel.addElement(new NamedEuclidean());
        distModel.addElement(new LabeledManhattan());
        distModel.addElement(new Spearman());
        distModel.addElement(new JensenShannonMetric());
        distModel.addElement(new AngleMeasure());
        distanceBox = new JComboBox(distModel);

        normalizationBox = new NormalizationBox();

        ClusterAlgorithm selAlg = (ClusterAlgorithm) algorithmBox.getSelectedItem();
        parametersPanel = selAlg.getParameterPanel();

        algorithmBox.addItemListener(new ItemListener() {
            @Override
            public void itemStateChanged(ItemEvent e) {
                ClusterAlgorithm alg = (ClusterAlgorithm) algorithmBox.getSelectedItem();
                parametersPanel = alg.getParameterPanel();
                buildGroups();

                ClusteringDefinitionPanel.this.mainPanel.invalidate();
                ClusteringDefinitionPanel.this.mainPanel.validate();

            }
        });

        buildGroups();
        clusterButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                int[] columns = null;
                String[] labels = null;
                double[][] x = ds.getAsDouble();
                Normalization norm = (Normalization)normalizationBox.getSelectedItem();
                norm.normalize(x);

                DistanceMeasure distMeasure = (DistanceMeasure) distanceBox.getSelectedItem();
                ClusterAlgorithm alg = (ClusterAlgorithm) algorithmBox.getSelectedItem();
                clustering = alg.cluster(ds.toString(), x, distMeasure, normalizationBox.getSelectedItem().toString());
                inv.addClustering(clustering, ds.getDataFrame());
            }
        });
    }

    private final void buildGroups() {
        this.mainPanel.removeAll();
        layout.setHorizontalGroup(layout.createParallelGroup()
                .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup()
                                .addComponent(dsLabel)
                                .addComponent(algorithmLabel)
                                .addComponent(distanceLabel)
                                .addComponent(normalizationLabel))
                        .addGroup(layout.createParallelGroup()
                                .addComponent(dsValue)
                                .addComponent(algorithmBox)
                                .addComponent(distanceBox)
                                .addComponent(normalizationBox))
                )
                .addComponent(parametersPanel)
                .addComponent(clusterButton)
        );
        layout.setVerticalGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(Alignment.BASELINE)
                        .addComponent(dsLabel)
                        .addComponent(dsValue))                
                .addGroup(layout.createParallelGroup(Alignment.BASELINE)
                        .addComponent(algorithmLabel)
                        .addComponent(algorithmBox))
                .addGroup(layout.createParallelGroup(Alignment.BASELINE)
                        .addComponent(distanceLabel)
                        .addComponent(distanceBox))
                .addGroup(layout.createParallelGroup(Alignment.BASELINE)
                        .addComponent(normalizationLabel)
                        .addComponent(normalizationBox))
                .addComponent(parametersPanel)
                .addComponent(clusterButton)
        );

    }


    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof DataSetBox){
            ds = (DataSet)arg;
            dsValue.setText(ds.toString());
        }
    }
    public JPanel getPanel(){
        return this.mainPanel;
    }
}
