/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe.investigator;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedRangeCategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.rhwlab.LMS.dataframe.DataSet;
import org.rhwlab.LMS.dataframe.investigator.DataSetAttributesPanel;

/**
 *
 * @author gevirl
 */
public class BoxAndWhiskerPanel extends ChartPanel {

    public BoxAndWhiskerPanel(String title, DataSet ds, int[] rows, DataSetAttributesPanel dsaPanel) {
        super(buildChart(title, ds, rows, dsaPanel));
    }

    static JFreeChart buildChart(String title, DataSet ds, int[] rows, DataSetAttributesPanel dsaPanel) {

        // set up the category keys based on selected attributes and all attributes of the input dataset
        List<String> selAttrs = dsaPanel.getSelectedAttributes();
        Set<String> allAttrs = ds.getAttributes();
        TreeSet<String> selAttrSet = new TreeSet<>();
        selAttrSet.addAll(selAttrs);
        String rowKeyAttr = selAttrs.get(0);
        String colKeyAttr = null;
        if (selAttrs.size() > 1) {
            colKeyAttr = selAttrs.get(1);
        }
        String[] chartKeyAttrs = null;
        int len = allAttrs.size() - selAttrs.size();
        if (len > 0) {
            chartKeyAttrs = new String[len]; // len is number of separate charts to make
            int i = 0;
            for (String attr : allAttrs) {
                if (!selAttrSet.contains(attr)) {
                    chartKeyAttrs[i] = attr;
                    ++i;
                }
            }
        }

        // construct all the data sets for the plots
        TreeMap<String, TreeMap<String, TreeMap<String, List<Double>>>> allX = new TreeMap<>(); // chart,row,col keys -> data list
        for (int c = 0; c < ds.getColumns().length; ++c) {
            String rowKey = ds.getAttribute(rowKeyAttr, c);
            String colKey = ds.getAttribute(rowKeyAttr, 0);
            if (colKeyAttr != null) {
                colKey = ds.getAttribute(colKeyAttr, c);
            }
            String chartKey = "";
            if (chartKeyAttrs != null) {
                StringBuilder builder = new StringBuilder();
                for (String chartKeyAttr : chartKeyAttrs) {
                    builder.append(ds.getAttribute(chartKeyAttr, c));
                    builder.append(" ");
                }
                chartKey = builder.toString();
            }
            
            TreeMap<String, TreeMap<String, List<Double>>> chartX = allX.get(chartKey);
            if (chartX == null){
                chartX = new TreeMap<>();
                allX.put(chartKey, chartX);
            }
            
            TreeMap<String, List<Double>> rowX = chartX.get(rowKey);
            if (rowX == null){
                rowX = new TreeMap<>();
                chartX.put(rowKey,rowX);
            }
            
            List<Double> xList = rowX.get(colKey);
            if (xList == null){
                xList = new ArrayList<>();
                rowX.put(colKey, xList);
            }
            
            for (int r = 0; r < rows.length; ++r) {
                int row = rows[r];
                xList.add(ds.getData(row, c));
                
            }
        }

        // build the box and whisker plots
        CombinedRangeCategoryPlot combplot = new CombinedRangeCategoryPlot();
        BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
        LineAndShapeRenderer renderer2 = new LineAndShapeRenderer();
        renderer2.setBasePaint(Color.black);
        
        for (String chartKey : allX.keySet()){
            DefaultBoxAndWhiskerCategoryDataset bwDataset = new DefaultBoxAndWhiskerCategoryDataset();
            DefaultCategoryDataset lineDataset = new DefaultCategoryDataset();
            
            TreeMap<String,TreeMap<String,List<Double>>> chartX = allX.get(chartKey);
            for (String rowKey : chartX.keySet()){
                TreeMap<String,List<Double>> rowX = chartX.get(rowKey);
                for (String colKey : rowX.keySet()){
                    List<Double> xList = rowX.get(colKey);
                    bwDataset.add(xList, rowKey, colKey);
                    Number mean = bwDataset.getMeanValue(rowKey,colKey);
//                    lineDataset.addValue(mean, rowKey, colKey);
                    double mu = 0.0;
                    for (Double d : xList){
                        mu = mu + d;
                    }
                    mu = mu/xList.size();
                    lineDataset.addValue(mu,colKey,rowKey);                    
                }
            }
            
            CategoryAxis categoryAxis = new CategoryAxis(chartKey);
            NumberAxis valueAxis = new NumberAxis("Expression");
            valueAxis.setAutoRangeIncludesZero(false);

            
            renderer.setBaseToolTipGenerator(new BoxAndWhiskerToolTipGenerator());

            CategoryPlot plot = new CategoryPlot(bwDataset, categoryAxis, valueAxis,
                    renderer);

            
            plot.setDataset(1, lineDataset);
            plot.setRenderer(1, renderer2);
    //        plot.mapDatasetToRangeAxis(1, 1);

    //        renderer2.setUseSeriesOffset(true);
            renderer2.setBaseLinesVisible(true);
            renderer2.setSeriesLinesVisible(0,true);
            renderer2.setSeriesLinesVisible(1,true);  
            renderer2.setSeriesPaint(0, Color.BLACK);
            plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
            combplot.add(plot);            
        }
        
        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT,combplot, false);        
    }
}
