/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe;

import org.rhwlab.LMS.dataframe.GeneExpression;
import com.jujutsu.tsne.barneshut.BHTSne;
import com.jujutsu.tsne.barneshut.BarnesHutTSne;
import com.jujutsu.tsne.barneshut.TSneConfiguration;
import com.jujutsu.utils.TSneUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JFrame;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import org.math.plot.FrameView;
import org.math.plot.Plot2DPanel;
import org.math.plot.plots.ColorBrewer;
import org.math.plot.plots.ColoredScatterPlot;
import org.math.plot.plots.ScatterPlot;

/**
 *
 * @author gevirl
 */
// perfomr T-sne dimensional reduction on data frame
public class Tsne implements Runnable {
    DataFrame dataFrame;
    int firstCol;
    int lastCol;
    int iter = 2000;
    String[] headers;
    
    public Tsne(DataFrame frame,int first,int last,String[] headers){
        this.firstCol=first;
        this.lastCol=last;
        this.dataFrame = frame;
        this.headers = headers;
    }

    static public void plot(File file)throws Exception {
        TreeMap<String,List<String[]>> dataMap = new TreeMap<>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null){
            String[] tokens = line.split(",");
            List<String[]> list = dataMap.get(tokens[0]);
            if (list == null){
                list = new ArrayList<>();
                dataMap.put(tokens[0],list);
            }
            list.add(tokens) ;
            line = reader.readLine();
        }
        reader.close();
        
        ColorBrewer[] brewers = ColorBrewer.getDivergingColorPalettes(true); 
        brewers = ColorBrewer.getQualitativeColorPalettes(true);
        Color[] colors = brewers[0].getColorPalette(dataMap.size());
        
        Plot2DPanel plot = new Plot2DPanel();
        int j=0;
        for (String label : dataMap.keySet()){
            int i=0;
            List<String[]> data = dataMap.get(label);
            double[][] XY = new double[data.size()][];
            for (String[] tokens : data){
                XY[i] = new double[2];
                XY[i][0] = Double.valueOf(tokens[3]);
                XY[i][1] = Double.valueOf(tokens[4]);
                ++i;
            }
            
            plot.addScatterPlot(label, colors[j], XY);
            ++j;
        }
        
      
        plot.plotCanvas.setNotable(true);
        plot.plotCanvas.setNoteCoords(true);
                
        plot.addLegend("SOUTH");
        
        FrameView plotframe = new FrameView(plot);
        plotframe.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        plotframe.setVisible(true);         
    }
    @Override
    public void run() {

        double[][] X = dataFrame.getAsDouble(firstCol, lastCol);
        TSneConfiguration config = TSneUtils.buildConfig(X, 2, X[0].length, 20, iter);
        BarnesHutTSne tsne = new BHTSne();
        double[][] Y = tsne.tsne(config); 
        dataFrame.addColumns(Y, headers);
    }
  
}
