/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.math.plot.canvas.Plot2DCanvas;
import org.math.plot.plots.Plot;

/**
 *
 * @author gevirl
 */
public class MouseNotifyingCanvas extends Plot2DCanvas {
    static int crossLen = 10;
    ArrayList<double[]> crossHairs = new ArrayList<>();
    
    public void clearCrossHairs(){
        crossHairs.clear();
    }
    public void setCrossHair(double[] x){
        crossHairs.add(x);
    }
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        for (int i = 0; i < plots.size(); i++) {
            if (getPlot(i).isSelected(mouseClick, draw) != null) {
                GeneScatterPlot scatter = (GeneScatterPlot)getPlot(i);
                scatter.notifyListeners();
                return;
            }
        }
    }
    public ArrayList<Plot> selectedPlots(int[] mouseLoc){
        ArrayList<Plot> ret = new ArrayList<>();
        for (int i = 0; i < plots.size(); ++i) {
            if (getPlot(i).isSelected(mouseLoc, draw) != null) {
                ret.add(getPlot(i));
            }  
        }
        return ret;
    }
    public int[] project(double[] xy){
        return draw.project(xy);
    }
    public void paint(Graphics gcomp) {
        super.paint(gcomp);
        Graphics2D gcomp2D = (Graphics2D) gcomp;
        for (double[] cross : crossHairs){
            int[] c = project(cross);

            gcomp2D.setColor(Color.black);
            gcomp2D.drawLine(c[0]-crossLen, c[1], c[0]+crossLen, c[1]);
            gcomp2D.drawLine(c[0], c[1]-crossLen, c[0], c[1]+crossLen);
        }
    }
}
