/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.rhwlab.LMS.dataframe;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;

/**
 *
 * @author gevirl
 */
public class Kmeans {
    DataFrame df;
    String[] clusterLabels;
    int nClusters;
    int iterations = 1000;
    
    public Kmeans(DataFrame df)    {
        this.df=df;
    }
    public String[] getClusterLabels(){
        return this.clusterLabels;
    }    
    public void cluster(int nClusters,double[][] x,DistanceMeasure dist){
        ArrayList<Clusterable> collect = new ArrayList<>();
        int i=0;
        for (double[] row : x){
            collect.add(new LabeledClusterable(row,i));
            ++i;
        }     
        KMeansPlusPlusClusterer clusterer = new KMeansPlusPlusClusterer(nClusters,iterations,dist);
        List<CentroidCluster<Clusterable>> list = clusterer.cluster(collect); 
                clusterLabels = new String[x.length];
        i=1;
        for (Cluster cluster : list){
            
            String label = Integer.toString(i);
            ++i;
            System.out.printf("Cluster %s: %d points\n", label,cluster.getPoints().size());
            for (Object obj : cluster.getPoints()){
                LabeledClusterable clusterable = (LabeledClusterable)obj;
                clusterLabels[clusterable.getLabel()] = label;
            }
        }
    }
}
