#!/bin/bash

JVM="java"
JVMPAR="-Xmx70G"
QORTS="QoRTs.jar"

par='QC --runFunctions writeKnownSplices,writeNovelSplices,writeSpliceExon,writeDESeq'

fcsv="adam.180125.csv"
ldir=`cat $fcsv | grep -v selector | grep -v '#' | awk 'BEGIN{FS=","}{print$10}'`
for dir in $ldir;
do
  echo $dir
  qdir=$dir/QoRTs.protein-coding_genes
  echo "qdir $qdir"
  mkdir -p $qdir
  fbam="$dir/Aligned.toGenome.out.bam"
#  fgtf="c_elegans.PRJNA13758.WS245.annotations.wormbase.locus_and_biotype.protein-coding.exons.nm_wchr.gtf"
  fgtf="c_elegans.PRJNA13758.WS245.annotations.wormbase.locus_and_biotype.protein-coding.exons.nm_wchr.gtf.no_overlap_both_strands"
  dout="$qdir"
  pushd $qdir
  $JVM $JVMPAR -jar $QORTS $par $fbam $fgtf $dout
  popd
done
