library(JunctionSeq)
decoder.file="decoder.bySample.txt"
gff.file="mrgCts/withNovel.forJunctionSeq.gff.gz"
decoder=read.table( decoder.file, header=TRUE, stringsAsFactors=FALSE, sep="\t" )
countFiles=paste0( "mrgCts/", decoder$sample.ID, "/QC.spliceJunctionAndExonCounts.withNovel.forJunctionSeq.txt.gz" )
system( "mkdir -p results" )
jscs=runJunctionSeqAnalyses( sample.files=countFiles, sample.names=decoder$sample.ID, condition=factor( decoder$group.ID), flat.gff.file=gff.file, nCores=4, analysis.type="junctionsAndExons", method.dispFinal="shrink", optimizeFilteringForAlpha=0.1, use.multigene.aggregates=TRUE )
writeCompleteResults( jscs, outfile.prefix="results/run.", FDR.threshold=0.1, save.jscs=TRUE)
