args <- (commandArgs(TRUE))
for(i in 1:length(args))
{
  eval(parse(text=args[[i]]))
}

if( decoderFile == '' | contrastFile == '' | alpha == '' | lfcThreshold == '' )
{
  cat( "Error: missing argument: decoderFile or contrastFile or alpha or lfcThreshold\n" )
  cat( "  decoderFile: ", decoderFile, "\n" )
  cat( "  contrastFile: ", contrastFile, "\n" )
  cat( "  alpha: ", alpha, "\n" )
  cat( "  lfcThreshold: ", lfcThreshold, "\n" )
  stop( "missing argument: decoderFile or contrastFile or alpha or lfcThreshold\n" )
}
#
library( DESeq2 )
#
alpha <- as.numeric( alpha )
lfcThreshold <- as.numeric( lfcThreshold )
runID <- paste0( "run" )
logFile <- paste0( runID, ".log" )
directory <- "rawCts/"
#
decoder <- read.table( decoderFile, header=TRUE, stringsAsFactors=FALSE, sep="\t" )
sampleFiles <- paste0( decoder$sample.ID, "/QC.geneCounts.formatted.for.DESeq.txt.gz" )
sampleName <- decoder$sample.ID
sampleCondition <- decoder$group.ID
sampleTable <- data.frame( sampleName = sampleName, filename = sampleFiles, condition = sampleCondition )
contrast <- read.table( contrastFile, header=TRUE, stringsAsFactors=FALSE, sep="\t" )
#
write( paste0( "alpha: ", toString( alpha ) ), file=logFile, append=TRUE )
write( paste0( "lfcThreshold: ", toString( lfcThreshold ) ), file=logFile, append=TRUE )
write( paste0( "decoder file: ", decoderFile ), file=logFile, append=TRUE )
write( paste0( "count directory: ", directory ), file=logFile, append=TRUE )
write( paste0( "contrast filename: ", contrastFile ), file=logFile, append=TRUE )
#
dds <- DESeqDataSetFromHTSeqCount( sampleTable = sampleTable, directory = directory, design = ~ condition )
dds <- DESeq( dds, betaPrior=FALSE )
#
rld <- rlog( dds, blind=F )
outFilename <- paste0( runID, ".RData" )
save.image( file=outFilename )
#
outFilename <- paste0( runID, ".sizeFactors.txt" )
write.table( as.data.frame( sizeFactors( dds ) ), file=outFilename )
#
rld.assay <- assay( rld )
outFilename <- paste0( runID, ".rld.assay.txt" )
write.table( rld.assay, file=outFilename )
#
outFilename <- paste0( runID, ".plotPCA.ps" )
ps.on( outFilename, hmod=T )
plotPCA( rld, intgroup="condition" )
ps.off()
#
outFilename <- paste0( runID, ".plotDispEsts.ps" )
ps.on( outFilename, hmod=T )
plotDispEsts( dds )
ps.off()
#
binwid = .01
outFilename <- paste0( runID, ".gene_expression.txt" )
write.table( as.data.frame( assays( dds )[["mu"]] ), quote=FALSE, file=outFilename )
#
for( i in 1:nrow( contrast ) )
{
  group1 <- contrast[i,1]
  group2 <- contrast[i,2]
  outID <- contrast[i,3]
  #
  res <- results( dds, contrast=c( "condition", group2, group1 ), alpha=alpha, lfcThreshold=lfcThreshold, altHypothesis="lessAbs" )
  resOrdered <- res[order(res$padj),]
  #
  outFilename <- paste0( runID, ".", outID, ".results.txt" )
  write.table( as.data.frame( resOrdered ), quote=FALSE, file=outFilename )
  #
  outFilename <- paste0( runID, ".", outID, ".plotMA.ps" )
  m.main <- paste0( "MA plot: ", outID )
  ps.on( outFilename, hmod=T )
  plotMA( res, alpha=alpha, main=m.main )
  ps.off()
  #
  flag <- is.na( res$pvalue )
  outFilename <- paste0( runID, ".", outID, ".plotPvalue.ps" )
  m.main <- paste0( "P-value histogram: ", outID )
  ps.on( outFilename, hmod=T )
  m.range = range( res$pvalue[!flag] )
  m.breaks = ( m.range[2] - m.range[1] ) / binwid
  hist( res$pvalue[!flag], breaks=m.breaks, main=m.main, xlab="P-value" )
  ps.off()
}

